/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class Network
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int nNodes;
    protected int nEdges;
    protected double[] nodeWeight;
    protected int[] firstNeighborIndex;
    protected int[] neighbor;
    protected double[] edgeWeight;
    protected double totalEdgeWeightSelfLinks;

    public static Network load(String string) throws ClassNotFoundException, IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
        Network network = (Network)objectInputStream.readObject();
        objectInputStream.close();
        return network;
    }

    public Network(int n, int[][] nArray) {
        this(n, null, nArray, null);
    }

    public Network(int n, double[] dArray, int[][] nArray) {
        this(n, dArray, nArray, null);
    }

    public Network(int n, int[][] nArray, double[] dArray) {
        this(n, null, nArray, dArray);
    }

    public Network(int n, double[] dArray, int[][] nArray, double[] dArray2) {
        this.nNodes = n;
        this.nEdges = 0;
        this.firstNeighborIndex = new int[n + 1];
        int[] nArray2 = new int[nArray[0].length];
        double[] dArray3 = new double[nArray[0].length];
        this.totalEdgeWeightSelfLinks = 0.0;
        int n2 = 1;
        for (int i = 0; i < nArray[0].length; ++i) {
            if (nArray[0][i] != nArray[1][i]) {
                if (nArray[0][i] >= n2) {
                    while (n2 <= nArray[0][i]) {
                        this.firstNeighborIndex[n2] = this.nEdges;
                        ++n2;
                    }
                }
                nArray2[this.nEdges] = nArray[1][i];
                dArray3[this.nEdges] = dArray2 != null ? dArray2[i] : 1.0;
                ++this.nEdges;
                continue;
            }
            this.totalEdgeWeightSelfLinks += dArray2 != null ? dArray2[i] : 1.0;
        }
        while (n2 <= n) {
            this.firstNeighborIndex[n2] = this.nEdges;
            ++n2;
        }
        this.neighbor = Arrays.copyOfRange(nArray2, 0, this.nEdges);
        this.edgeWeight = Arrays.copyOfRange(dArray3, 0, this.nEdges);
        this.nodeWeight = dArray != null ? (double[])dArray.clone() : this.getTotalEdgeWeightPerNode();
    }

    public Network(int n, int[] nArray, int[] nArray2) {
        this(n, null, nArray, nArray2, null);
    }

    public Network(int n, double[] dArray, int[] nArray, int[] nArray2) {
        this(n, dArray, nArray, nArray2, null);
    }

    public Network(int n, int[] nArray, int[] nArray2, double[] dArray) {
        this(n, null, nArray, nArray2, dArray);
    }

    public Network(int n, double[] dArray, int[] nArray, int[] nArray2, double[] dArray2) {
        this.nNodes = n;
        this.nEdges = nArray2.length;
        this.firstNeighborIndex = (int[])nArray.clone();
        this.neighbor = (int[])nArray2.clone();
        if (dArray2 != null) {
            this.edgeWeight = (double[])dArray2.clone();
        } else {
            this.edgeWeight = new double[this.nEdges];
            Arrays.fill(this.edgeWeight, 1.0);
        }
        this.totalEdgeWeightSelfLinks = 0.0;
        this.nodeWeight = dArray != null ? (double[])dArray.clone() : this.getTotalEdgeWeightPerNode();
    }

    public void save(String string) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
        objectOutputStream.writeObject(this);
        objectOutputStream.close();
    }

    public int getNNodes() {
        return this.nNodes;
    }

    public double getTotalNodeWeight() {
        return Arrays2.calcSum(this.nodeWeight);
    }

    public double[] getNodeWeights() {
        return (double[])this.nodeWeight.clone();
    }

    public double getNodeWeight(int n) {
        return this.nodeWeight[n];
    }

    public int getNEdges() {
        return this.nEdges / 2;
    }

    public int getNEdges(int n) {
        return this.firstNeighborIndex[n + 1] - this.firstNeighborIndex[n];
    }

    public int[] getNEdgesPerNode() {
        int[] nArray = new int[this.nNodes];
        for (int i = 0; i < this.nNodes; ++i) {
            nArray[i] = this.firstNeighborIndex[i + 1] - this.firstNeighborIndex[i];
        }
        return nArray;
    }

    public int[][] getEdges() {
        int[][] nArrayArray = new int[2][];
        nArrayArray[0] = new int[this.nEdges];
        for (int i = 0; i < this.nNodes; ++i) {
            Arrays.fill(nArrayArray[0], this.firstNeighborIndex[i], this.firstNeighborIndex[i + 1], i);
        }
        nArrayArray[1] = (int[])this.neighbor.clone();
        return nArrayArray;
    }

    public int[] getEdges(int n) {
        return Arrays.copyOfRange(this.neighbor, this.firstNeighborIndex[n], this.firstNeighborIndex[n + 1]);
    }

    public int[][] getEdgesPerNode() {
        int[][] nArrayArray = new int[this.nNodes][];
        for (int i = 0; i < this.nNodes; ++i) {
            nArrayArray[i] = Arrays.copyOfRange(this.neighbor, this.firstNeighborIndex[i], this.firstNeighborIndex[i + 1]);
        }
        return nArrayArray;
    }

    public double getTotalEdgeWeight() {
        return Arrays2.calcSum(this.edgeWeight) / 2.0;
    }

    public double getTotalEdgeWeight(int n) {
        return Arrays2.calcSum(this.edgeWeight, this.firstNeighborIndex[n], this.firstNeighborIndex[n + 1]);
    }

    public double[] getTotalEdgeWeightPerNode() {
        double[] dArray = new double[this.nNodes];
        for (int i = 0; i < this.nNodes; ++i) {
            dArray[i] = Arrays2.calcSum(this.edgeWeight, this.firstNeighborIndex[i], this.firstNeighborIndex[i + 1]);
        }
        return dArray;
    }

    public double[] getEdgeWeights() {
        return (double[])this.edgeWeight.clone();
    }

    public double[] getEdgeWeights(int n) {
        return Arrays.copyOfRange(this.edgeWeight, this.firstNeighborIndex[n], this.firstNeighborIndex[n + 1]);
    }

    public double[][] getEdgeWeightsPerNode() {
        double[][] dArrayArray = new double[this.nNodes][];
        for (int i = 0; i < this.nNodes; ++i) {
            dArrayArray[i] = Arrays.copyOfRange(this.edgeWeight, this.firstNeighborIndex[i], this.firstNeighborIndex[i + 1]);
        }
        return dArrayArray;
    }

    public double getTotalEdgeWeightSelfLinks() {
        return this.totalEdgeWeightSelfLinks;
    }

    public Network createNetworkWithoutNodeWeights() {
        Network network = new Network();
        network.nNodes = this.nNodes;
        network.nEdges = this.nEdges;
        network.nodeWeight = new double[this.nNodes];
        Arrays.fill(network.nodeWeight, 1.0);
        network.firstNeighborIndex = this.firstNeighborIndex;
        network.neighbor = this.neighbor;
        network.edgeWeight = this.edgeWeight;
        network.totalEdgeWeightSelfLinks = this.totalEdgeWeightSelfLinks;
        return network;
    }

    public Network createNetworkWithoutEdgeWeights() {
        Network network = new Network();
        network.nNodes = this.nNodes;
        network.nEdges = this.nEdges;
        network.nodeWeight = this.nodeWeight;
        network.firstNeighborIndex = this.firstNeighborIndex;
        network.neighbor = this.neighbor;
        network.edgeWeight = new double[this.nEdges];
        Arrays.fill(network.edgeWeight, 1.0);
        network.totalEdgeWeightSelfLinks = 0.0;
        return network;
    }

    public Network createNetworkWithoutNodeAndEdgeWeights() {
        Network network = new Network();
        network.nNodes = this.nNodes;
        network.nEdges = this.nEdges;
        network.nodeWeight = new double[this.nNodes];
        Arrays.fill(network.nodeWeight, 1.0);
        network.firstNeighborIndex = this.firstNeighborIndex;
        network.neighbor = this.neighbor;
        network.edgeWeight = new double[this.nEdges];
        Arrays.fill(network.edgeWeight, 1.0);
        network.totalEdgeWeightSelfLinks = 0.0;
        return network;
    }

    public Network createNormalizedNetwork1() {
        Network network = new Network();
        network.nNodes = this.nNodes;
        network.nEdges = this.nEdges;
        network.nodeWeight = new double[this.nNodes];
        Arrays.fill(network.nodeWeight, 1.0);
        network.firstNeighborIndex = this.firstNeighborIndex;
        network.neighbor = this.neighbor;
        network.edgeWeight = new double[this.nEdges];
        double d = this.getTotalNodeWeight();
        for (int i = 0; i < this.nNodes; ++i) {
            for (int j = this.firstNeighborIndex[i]; j < this.firstNeighborIndex[i + 1]; ++j) {
                network.edgeWeight[j] = this.edgeWeight[j] / (this.nodeWeight[i] * this.nodeWeight[this.neighbor[j]] / d);
            }
        }
        network.totalEdgeWeightSelfLinks = 0.0;
        return network;
    }

    public Network createNormalizedNetwork2() {
        Network network = new Network();
        network.nNodes = this.nNodes;
        network.nEdges = this.nEdges;
        network.nodeWeight = new double[this.nNodes];
        Arrays.fill(network.nodeWeight, 1.0);
        network.firstNeighborIndex = this.firstNeighborIndex;
        network.neighbor = this.neighbor;
        network.edgeWeight = new double[this.nEdges];
        for (int i = 0; i < this.nNodes; ++i) {
            for (int j = this.firstNeighborIndex[i]; j < this.firstNeighborIndex[i + 1]; ++j) {
                network.edgeWeight[j] = this.edgeWeight[j] / (2.0 / ((double)this.nNodes / this.nodeWeight[i] + (double)this.nNodes / this.nodeWeight[this.neighbor[j]]));
            }
        }
        network.totalEdgeWeightSelfLinks = 0.0;
        return network;
    }

    public Network createPrunedNetwork(int n) {
        return this.createPrunedNetwork(n, new Random());
    }

    public Network createPrunedNetwork(int n, Random random) {
        int n2;
        int n3;
        if ((n *= 2) >= this.nEdges) {
            return this;
        }
        double[] dArray = new double[this.nEdges / 2];
        int n4 = 0;
        for (n3 = 0; n3 < this.nNodes; ++n3) {
            for (n2 = this.firstNeighborIndex[n3]; n2 < this.firstNeighborIndex[n3 + 1]; ++n2) {
                if (this.neighbor[n2] >= n3) continue;
                dArray[n4] = this.edgeWeight[n2];
                ++n4;
            }
        }
        Arrays.sort(dArray);
        double d = dArray[(this.nEdges - n) / 2];
        int n5 = 0;
        while (dArray[this.nEdges / 2 - n5 - 1] > d) {
            ++n5;
        }
        int n6 = 0;
        while (n5 + n6 < this.nEdges / 2 && dArray[this.nEdges / 2 - n5 - n6 - 1] == d) {
            ++n6;
        }
        int[] nArray = Arrays2.generateRandomPermutation(this.nNodes, random);
        double[] dArray2 = new double[n6];
        n4 = 0;
        for (n3 = 0; n3 < this.nNodes; ++n3) {
            for (n2 = this.firstNeighborIndex[n3]; n2 < this.firstNeighborIndex[n3 + 1]; ++n2) {
                if (this.neighbor[n2] >= n3 || this.edgeWeight[n2] != d) continue;
                dArray2[n4] = this.generateRandomNumber(n3, this.neighbor[n2], nArray);
                ++n4;
            }
        }
        Arrays.sort(dArray2);
        double d2 = dArray2[n5 + n6 - n / 2];
        Network network = new Network();
        network.nNodes = this.nNodes;
        network.nEdges = n;
        network.nodeWeight = this.nodeWeight;
        network.firstNeighborIndex = new int[this.nNodes + 1];
        network.neighbor = new int[n];
        network.edgeWeight = new double[n];
        n4 = 0;
        for (n3 = 0; n3 < this.nNodes; ++n3) {
            for (n2 = this.firstNeighborIndex[n3]; n2 < this.firstNeighborIndex[n3 + 1]; ++n2) {
                if (!(this.edgeWeight[n2] > d) && (this.edgeWeight[n2] != d || !(this.generateRandomNumber(n3, this.neighbor[n2], nArray) >= d2))) continue;
                network.neighbor[n4] = this.neighbor[n2];
                network.edgeWeight[n4] = this.edgeWeight[n2];
                ++n4;
            }
            network.firstNeighborIndex[n3 + 1] = n4;
        }
        network.totalEdgeWeightSelfLinks = this.totalEdgeWeightSelfLinks;
        return network;
    }

    public Network createSubnetwork(int[] nArray) {
        Network network = new Network();
        network.nNodes = nArray.length;
        if (network.nNodes == 1) {
            network.nEdges = 0;
            network.nodeWeight = new double[]{this.nodeWeight[nArray[0]]};
            network.firstNeighborIndex = new int[2];
            network.neighbor = new int[0];
            network.edgeWeight = new double[0];
        } else {
            int n;
            int[] nArray2 = new int[this.nNodes];
            Arrays.fill(nArray2, -1);
            for (n = 0; n < nArray.length; ++n) {
                nArray2[nArray[n]] = n;
            }
            network.nEdges = 0;
            network.nodeWeight = new double[network.nNodes];
            network.firstNeighborIndex = new int[network.nNodes + 1];
            int[] nArray3 = new int[this.nEdges];
            double[] dArray = new double[this.nEdges];
            for (n = 0; n < network.nNodes; ++n) {
                int n2 = nArray[n];
                network.nodeWeight[n] = this.nodeWeight[n2];
                for (int i = this.firstNeighborIndex[n2]; i < this.firstNeighborIndex[n2 + 1]; ++i) {
                    if (nArray2[this.neighbor[i]] < 0) continue;
                    nArray3[network.nEdges] = nArray2[this.neighbor[i]];
                    dArray[network.nEdges] = this.edgeWeight[i];
                    ++network.nEdges;
                }
                network.firstNeighborIndex[n + 1] = network.nEdges;
            }
            network.neighbor = Arrays.copyOfRange(nArray3, 0, network.nEdges);
            network.edgeWeight = Arrays.copyOfRange(dArray, 0, network.nEdges);
        }
        network.totalEdgeWeightSelfLinks = 0.0;
        return network;
    }

    public Network createSubnetwork(boolean[] blArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.nNodes; ++n) {
            if (!blArray[n]) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        n2 = 0;
        for (n = 0; n < this.nNodes; ++n) {
            if (!blArray[n]) continue;
            nArray[n2] = n;
            ++n2;
        }
        return this.createSubnetwork(nArray);
    }

    public Network createSubnetwork(Clustering clustering, int n) {
        int[][] nArray = clustering.getNodesPerCluster();
        int[] nArray2 = new int[this.nNodes];
        int[] nArray3 = new int[this.nEdges];
        double[] dArray = new double[this.nEdges];
        Network network = this.createSubnetwork(clustering, n, nArray[n], nArray2, nArray3, dArray);
        return network;
    }

    public Network[] createSubnetworks(Clustering clustering) {
        Network[] networkArray = new Network[clustering.nClusters];
        int[][] nArray = clustering.getNodesPerCluster();
        int[] nArray2 = new int[this.nNodes];
        int[] nArray3 = new int[this.nEdges];
        double[] dArray = new double[this.nEdges];
        for (int i = 0; i < clustering.nClusters; ++i) {
            networkArray[i] = this.createSubnetwork(clustering, i, nArray[i], nArray2, nArray3, dArray);
        }
        return networkArray;
    }

    public Network createSubnetworkLargestComponent() {
        return this.createSubnetwork(this.identifyComponents(), 0);
    }

    public Network createReducedNetwork(Clustering clustering) {
        Network network = new Network();
        network.nNodes = clustering.nClusters;
        network.nEdges = 0;
        network.nodeWeight = new double[clustering.nClusters];
        network.firstNeighborIndex = new int[clustering.nClusters + 1];
        network.totalEdgeWeightSelfLinks = this.totalEdgeWeightSelfLinks;
        int[] nArray = new int[this.nEdges];
        double[] dArray = new double[this.nEdges];
        int[] nArray2 = new int[clustering.nClusters - 1];
        double[] dArray2 = new double[clustering.nClusters];
        int[][] nArray3 = clustering.getNodesPerCluster();
        for (int i = 0; i < clustering.nClusters; ++i) {
            int n;
            int n2 = 0;
            for (n = 0; n < nArray3[i].length; ++n) {
                int n3 = nArray3[i][n];
                int n4 = i;
                network.nodeWeight[n4] = network.nodeWeight[n4] + this.nodeWeight[n3];
                for (int j = this.firstNeighborIndex[n3]; j < this.firstNeighborIndex[n3 + 1]; ++j) {
                    int n5 = clustering.cluster[this.neighbor[j]];
                    if (n5 != i) {
                        if (dArray2[n5] == 0.0) {
                            nArray2[n2] = n5;
                            ++n2;
                        }
                        int n6 = n5;
                        dArray2[n6] = dArray2[n6] + this.edgeWeight[j];
                        continue;
                    }
                    network.totalEdgeWeightSelfLinks += this.edgeWeight[j];
                }
            }
            for (n = 0; n < n2; ++n) {
                nArray[network.nEdges + n] = nArray2[n];
                dArray[network.nEdges + n] = dArray2[nArray2[n]];
                dArray2[nArray2[n]] = 0.0;
            }
            network.nEdges += n2;
            network.firstNeighborIndex[i + 1] = network.nEdges;
        }
        network.neighbor = Arrays.copyOfRange(nArray, 0, network.nEdges);
        network.edgeWeight = Arrays.copyOfRange(dArray, 0, network.nEdges);
        return network;
    }

    public Clustering identifyComponents() {
        Clustering clustering = new Clustering(this.nNodes);
        clustering.nClusters = 0;
        boolean[] blArray = new boolean[this.nNodes];
        int[] nArray = new int[this.nNodes];
        for (int i = 0; i < this.nNodes; ++i) {
            if (blArray[i]) continue;
            clustering.cluster[i] = clustering.nClusters;
            blArray[i] = true;
            nArray[0] = i;
            int n = 1;
            int n2 = 0;
            do {
                for (int j = this.firstNeighborIndex[nArray[n2]]; j < this.firstNeighborIndex[nArray[n2] + 1]; ++j) {
                    if (blArray[this.neighbor[j]]) continue;
                    clustering.cluster[this.neighbor[j]] = clustering.nClusters;
                    blArray[this.neighbor[j]] = true;
                    nArray[n] = this.neighbor[j];
                    ++n;
                }
            } while (++n2 < n);
            ++clustering.nClusters;
        }
        clustering.orderClustersByNNodes();
        return clustering;
    }

    private Network() {
    }

    private double generateRandomNumber(int n, int n2, int[] nArray) {
        int n3;
        int n4;
        if (n < n2) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = n2;
            n3 = n;
        }
        Random random = new Random(nArray[n4] * this.nNodes + nArray[n3]);
        return random.nextDouble();
    }

    private Network createSubnetwork(Clustering clustering, int n, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) {
        Network network = new Network();
        network.nNodes = nArray.length;
        if (network.nNodes == 1) {
            network.nEdges = 0;
            network.nodeWeight = new double[]{this.nodeWeight[nArray[0]]};
            network.firstNeighborIndex = new int[2];
            network.neighbor = new int[0];
            network.edgeWeight = new double[0];
        } else {
            int n2;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray2[nArray[n2]] = n2;
            }
            network.nEdges = 0;
            network.nodeWeight = new double[network.nNodes];
            network.firstNeighborIndex = new int[network.nNodes + 1];
            for (n2 = 0; n2 < network.nNodes; ++n2) {
                int n3 = nArray[n2];
                network.nodeWeight[n2] = this.nodeWeight[n3];
                for (int i = this.firstNeighborIndex[n3]; i < this.firstNeighborIndex[n3 + 1]; ++i) {
                    if (clustering.cluster[this.neighbor[i]] != n) continue;
                    nArray3[network.nEdges] = nArray2[this.neighbor[i]];
                    dArray[network.nEdges] = this.edgeWeight[i];
                    ++network.nEdges;
                }
                network.firstNeighborIndex[n2 + 1] = network.nEdges;
            }
            network.neighbor = Arrays.copyOfRange(nArray3, 0, network.nEdges);
            network.edgeWeight = Arrays.copyOfRange(dArray, 0, network.nEdges);
        }
        network.totalEdgeWeightSelfLinks = 0.0;
        return network;
    }
}

