% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_modal.R
\name{CollapseSpeciesExpressionMatrix}
\alias{CollapseSpeciesExpressionMatrix}
\title{Slim down a multi-species expression matrix, when only one species is primarily of interenst.}
\usage{
CollapseSpeciesExpressionMatrix(data.matrix, prefix.1 = "HUMAN_",
  prefix.controls = "MOUSE_", features.controls.toKeep = 100)
}
\arguments{
\item{data.matrix}{A UMI count matrix. Should contain rownames that start with the ensuing arguments prefix.1 or prefix.2}

\item{prefix.1}{The prefix denoting rownames for the species of interest. Default is "HUMAN_". These rownames will have this prefix removed in the returned matrix.}

\item{prefix.controls}{The prefix denoting rownames for the species of 'negative control' cells. Default is "MOUSE_".}

\item{features.controls.toKeep}{How many of the most highly expressed (average) negative control features (by default, 100 mouse genes), should be kept? All other rownames starting with prefix.2 are discarded.}
}
\value{
A UMI count matrix. Rownames that started with prefix.1 have this prefix discarded. For rownames starting with prefix.2, only the most highly expressed features are kept, and the prefix is kept. All other rows are retained.
}
\description{
Valuable for CITE-seq analyses, where we typically spike in rare populations of 'negative control' cells from a different species.
}
\examples{
\dontrun{
cbmc.rna.collapsed <- CollapseSpeciesExpressionMatrix(cbmc.rna)
}
}
