% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{NegBinomDETest}
\alias{NegBinomDETest}
\title{Negative binomial test for UMI-count based data}
\usage{
NegBinomDETest(object, cells.1, cells.2, genes.use = NULL,
  latent.vars = NULL, print.bar = TRUE, min.cells = 3,
  assay.type = "RNA")
}
\arguments{
\item{object}{Seurat object}

\item{cells.1}{Group 1 cells}

\item{cells.2}{Group 2 cells}

\item{genes.use}{Genes to use for test}

\item{latent.vars}{Latent variables to test}

\item{print.bar}{Print progress bar}

\item{min.cells}{Minimum number of cells threshold}

\item{assay.type}{Type of assay to fetch data for (default is RNA)}
}
\value{
Returns a p-value ranked matrix of putative differentially expressed
genes.
}
\description{
Identifies differentially expressed genes between two groups of cells using
a negative binomial generalized linear model
}
\examples{
pbmc_small
# Note, not recommended for particularly small datasets - expect warnings
NegBinomDETest(pbmc_small, cells.1 = WhichCells(object = pbmc_small, ident = 1),
            cells.2 = WhichCells(object = pbmc_small, ident = 2))

}
