% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction.R
\name{RunUMAP}
\alias{RunUMAP}
\title{Run UMAP}
\usage{
RunUMAP(object, cells.use = NULL, dims.use = 1:5, reduction.use = "pca",
  genes.use = NULL, assay.use = "RNA", max.dim = 2L,
  reduction.name = "umap", reduction.key = "UMAP", n_neighbors = 30L,
  min_dist = 0.3, metric = "correlation", seed.use = 42, ...)
}
\arguments{
\item{object}{Seurat object}

\item{cells.use}{Which cells to analyze (default, all cells)}

\item{dims.use}{Which dimensions to use as input features, used only if
\code{genes.use} is NULL}

\item{reduction.use}{Which dimensional reduction (PCA or ICA) to use for the
UMAP input. Default is PCA}

\item{genes.use}{If set, run UMAP on this subset of genes (instead of running on a
set of reduced dimensions). Not set (NULL) by default}

\item{assay.use}{Assay to pull data for when using \code{genes.use}}

\item{max.dim}{Max dimension to keep from UMAP procedure.}

\item{reduction.name}{dimensional reduction name, specifies the position in
the object$dr list. umap by default}

\item{reduction.key}{dimensional reduction key, specifies the string before
the number for the dimension names. UMAP by default}

\item{n_neighbors}{This determines the number of neighboring points used in
local approximations of manifold structure. Larger values will result in more
global structure being preserved at the loss of detailed local structure. In
general this parameter should often be in the range 5 to 50.}

\item{min_dist}{min_dist: This controls how tightly the embedding is allowed
compress points together. Larger values ensure embedded points are more
evenly distributed, while smaller values allow the algorithm to optimise more
accurately with regard to local structure. Sensible values are in the range
0.001 to 0.5.}

\item{metric}{metric: This determines the choice of metric used to measure
distance in the input space. A wide variety of metrics are already coded, and
a user defined function can be passed as long as it has been JITd by numba.}

\item{seed.use}{Set a random seed. By default, sets the seed to 42. Setting
NULL will not set a seed.}

\item{...}{Additional arguments to the umap}
}
\value{
Returns a Seurat object containing a UMAP representation
}
\description{
Runs the Uniform Manifold Approximation and Projection (UMAP) dimensional
reduction technique. To run, you must first install the umap-learn python
package (e.g. via pip install umap-learn). Details on this package can be
found here: \url{https://github.com/lmcinnes/umap}. For a more in depth
discussion of the mathematics underlying UMAP, see the ArXiv paper here:
\url{https://arxiv.org/abs/1802.03426}.
}
\examples{
\dontrun{
pbmc_small
# Run UMAP map on first 5 PCs
pbmc_small <- RunUMAP(object = pbmc_small, dims.use = 1:5)
# Plot results
DimPlot(object = pbmc_small, reduction.use = 'umap')
}

}
\references{
McInnes, L, Healy, J, UMAP: Uniform Manifold Approximation and Projection for Dimension Reduction, ArXiv e-prints 1802.03426, 2018
}
