% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/integration.R
\name{RunGraphLaplacian}
\alias{RunGraphLaplacian}
\alias{RunGraphLaplacian.Seurat}
\alias{RunGraphLaplacian.default}
\title{Run Graph Laplacian Eigendecomposition}
\usage{
RunGraphLaplacian(object, ...)

\method{RunGraphLaplacian}{Seurat}(
  object,
  graph,
  reduction.name = "lap",
  reduction.key = "LAP_",
  n = 50,
  verbose = TRUE,
  ...
)

\method{RunGraphLaplacian}{default}(object, n = 50, reduction.key = "LAP_", verbose = TRUE, ...)
}
\arguments{
\item{object}{A Seurat object}

\item{...}{Arguments passed to eigs_sym}

\item{graph}{The name of graph}

\item{reduction.name}{dimensional reduction name, lap by default}

\item{reduction.key}{dimensional reduction key, specifies the string before
the number for the dimension names. LAP by default}

\item{n}{Total Number of Eigenvectors to compute and store (50 by default)}

\item{verbose}{Print message and process}
}
\value{
Returns Seurat object with the Graph laplacian eigenvector
calculation stored in the reductions slot
}
\description{
Run a graph laplacian dimensionality reduction. It is used as a low
dimensional representation for a cell-cell graph. The input graph
should be symmetric
}
\concept{dimensional_reduction}
