% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gDisrim.R
\name{gDiscrim}
\alias{gDiscrim}
\title{Compute generalized item discrimination}
\usage{
gDiscrim(Data, k = 3, l = 1, u = 3, maxscore, minscore, x)
}
\arguments{
\item{Data}{matrix or data.frame of items to be examined. Rows represent
respondents, columns represent items.}

\item{k}{numeric: number of groups to which may be \code{Data} divided by
the total score. Default value is 3.  See \strong{Details}.}

\item{l}{numeric: lower group. Default value is 1. See \strong{Details}.}

\item{u}{numeric: upper group. Default value is 3. See \strong{Details}.}

\item{maxscore}{numeric: maximal score in ordinal items. If missing, vector
of obtained maximal scores is imputed. See \strong{Details}.}

\item{minscore}{numeric: minimal score in ordinal items. If missing, vector
of obtained minimal scores is imputed. See \strong{Details}.}

\item{x}{deprecated. Use argument \code{Data} instead.}
}
\description{
gDiscrim function computes various generalizations of
  discrimination index ULI. It enumerates the ability of item to distinguish
  between individuals from upper (U) vs. lower (L) ability groups, i.e.
  between respondents with high vs. low overall score on the test. Number of
  groups, as well as upper and lower groups can be specified by user. Maximal
  and minimal score in ordinal datasets can be specified by user.
}
\details{
The function computes total test scores for all respondents and then
  divides the respondents into \code{k} groups. The lower and upper groups
  are determined by \code{l} and \code{u} parameters, i.e., l-th and u-th
  group where the ordering is defined by increasing total score.

  In ordinal items, difficulty is calculated as difference of average score
  divided by range (maximal possible score \code{maxscore} minus minimal
  possible score \code{minscore} for given item).

  Discrimination is calculated as difference in difficulty between upper and
  lower group.
}
\note{
\code{gDiscrim} is used by \code{\link{DDplot}} function.
}
\examples{
# loading 100-item medical admission test datasets
data(dataMedical, dataMedicalgraded)
# binary dataset
dataBin <- dataMedical[, 1:100]
# ordinal dataset
dataOrd <- dataMedicalgraded[, 1:100]

# ULI for the first 5 items of binary dataset
# compare to psychometric::discrim(dataBin)
gDiscrim(dataBin)[1:5]
# generalized ULI using 5 groups, compare 4th and 5th for binary dataset
gDiscrim(dataBin, k = 5, l = 4, u = 5)[1:5]

# ULI for first 5 items for ordinal dataset
gDiscrim(dataOrd)[1:5]
# generalized ULI using 5 groups, compare 4th and 5th for binary dataset
gDiscrim(dataOrd, k = 5, l = 4, u = 5)[1:5]
# maximum (4) and minimum (0) score are same for all items
gDiscrim(dataOrd, k = 5, l = 4, u = 5, maxscore = 4, minscore = 0)[1:5]
}
\references{
Martinkova, P., Stepanek, L., Drabinova, A., Houdek, J.,
Vejrazka, M., & Stuka, C. (2017). Semi-real-time analyses of item
characteristics for medical school admission tests. In: Proceedings of the
2017 Federated Conference on Computer Science and Information Systems.
https://doi.org/10.15439/2017F380
}
\seealso{
\code{\link{DDplot}}
}
\author{
Adela Hladka \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Lubomir Stepanek \cr
Charles University \cr

Jana Vorlickova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
