% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motifs.R
\name{MotifCounts}
\alias{MotifCounts}
\title{Count fragments surrounding motif sites}
\usage{
MotifCounts(
  object,
  motifs,
  flanking.region = 1000,
  assay = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat object}

\item{motifs}{A list of DNA sequence motif names. One matrix will be generated
for each motif}

\item{flanking.region}{Amount of sequence to include surrounding the motif
itself}

\item{assay}{Name of assay to use. Must be a ChromatinAssay}

\item{verbose}{Display messages}

\item{...}{Additional arguments passed to \code{\link{FeatureMatrix}}}
}
\value{
Returns a list of sparse matrices
}
\description{
Count the number of sequenced DNA fragments in a region surrounding each 
instance of a given DNA sequence motif.
}
