% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{GetGRangesFromEnsDb}
\alias{GetGRangesFromEnsDb}
\title{Extract genomic ranges from EnsDb object}
\usage{
GetGRangesFromEnsDb(
  ensdb,
  standard.chromosomes = TRUE,
  biotypes = c("protein_coding", "lincRNA", "rRNA", "processed_transcript"),
  verbose = TRUE
)
}
\arguments{
\item{ensdb}{An EnsDb object}

\item{standard.chromosomes}{Keep only standard chromosomes}

\item{biotypes}{Biotypes to keep}

\item{verbose}{Display messages}
}
\description{
Pulls the transcript information for all chromosomes from an EnsDb object.
This wraps \code{\link[biovizBase]{crunch}} and applies the extractor
function to all chromosomes present in the EnsDb object.
}
\concept{utilities}
