% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printSimBIID_runs.R
\name{print.SimBIID_runs}
\alias{print.SimBIID_runs}
\title{Prints \code{SimBIID_runs} objects}
\usage{
\method{print}{SimBIID_runs}(x, ...)
}
\arguments{
\item{x}{A \code{SimBIID_runs} object.}

\item{...}{Not used here.}
}
\value{
Summary outputs printed to the screen.
}
\description{
Print method for \code{SimBIID_runs} objects.
}
\examples{
\donttest{
## set up SIR simulation model
transitions <- c(
    "S -> beta * S * I -> I", 
    "I -> gamma * I -> R"
)
compartments <- c("S", "I", "R")
pars <- c("beta", "gamma")
model <- mparseRcpp(
    transitions = transitions, 
    compartments = compartments,
    pars = pars,
    tspan = TRUE
)

## run 100 replicate simulations and
## plot outputs
sims <- run(
    model = model,
    pars = c(beta = 0.001, gamma = 0.1),
    tstart = 0,
    tstop = 100,
    u = c(S = 119, I = 1, R = 0),
    tspan = seq(1, 100, length.out = 10),
    nrep = 100
)
sims
}

}
\seealso{
\code{\link{mparseRcpp}}, \code{\link{plot.SimBIID_runs}}, \code{\link{run}}
}
