% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord_norm.R
\name{ord_norm}
\alias{ord_norm}
\title{Calculate Intermediate MVN Correlation to Generate Variables Treated as Ordinal}
\usage{
ord_norm(marginal = list(), rho = NULL, support = list(),
  epsilon = 0.001, maxit = 1000, Spearman = FALSE)
}
\arguments{
\item{marginal}{a list of length equal to the number of variables; the i-th element is a vector of the cumulative
probabilities defining the marginal distribution of the i-th variable;
if the variable can take r values, the vector will contain r - 1 probabilities (the r-th is assumed to be 1)}

\item{rho}{the target correlation matrix}

\item{support}{a list of length equal to the number of variables; the i-th element is a vector of containing the r
ordered support values; if not provided (i.e. support = list()), the default is for the i-th element to be the vector 1, ..., r}

\item{epsilon}{the maximum acceptable error between the final and target pairwise correlations (default = 0.001);
smaller values take more time}

\item{maxit}{the maximum number of iterations to use (default = 1000) to find the intermediate correlation; the
correction loop stops when either the iteration number passes \code{maxit} or \code{epsilon} is reached}

\item{Spearman}{if TRUE, Spearman's correlations are used (and support is not required); if FALSE (default) Pearson's correlations
are used}
}
\value{
A list with the following components:

\code{SigmaC} the intermediate MVN correlation matrix

\code{rho0} the calculated final correlation matrix generated from \code{SigmaC}

\code{rho} the target final correlation matrix

\code{niter} a matrix containing the number of iterations required for each variable pair

\code{maxerr} the maximum final error between the final and target correlation matrices
}
\description{
This function calculates the intermediate MVN correlation needed to generate a variable described by
    a discrete marginal distribution and associated finite support.  This includes ordinal (\eqn{r \ge 2} categories) variables
    or variables that are treated as ordinal (i.e. count variables in the Barbiero & Ferrari, 2015 method used in
    \code{\link[SimCorrMix]{corrvar2}}, \doi{10.1002/asmb.2072}).  The function is a modification of Barbiero & Ferrari's
    \code{\link[GenOrd]{ordcont}} function in \code{\link[GenOrd]{GenOrd-package}}.
    It works by setting the intermediate MVN correlation equal to the target correlation and updating each intermediate pairwise
    correlation until the final pairwise correlation is within \code{epsilon} of the target correlation or the maximum number of
    iterations has been reached.  This function uses \code{\link[SimCorrMix]{norm_ord}} to calculate the ordinal correlation obtained
    from discretizing the normal variables generated from the intermediate correlation matrix.  The \code{\link[GenOrd]{ordcont}} has been modified in the following ways:

    1) the initial correlation check has been removed because this is done within the simulation functions

    2) the final positive-definite check has been removed

    3) the intermediate correlation update function was changed to accommodate more situations

    This function would not ordinarily be called by the user.  Note that this will return a matrix that is NOT positive-definite
    because this is corrected for in the simulation functions \code{\link[SimCorrMix]{corrvar}} and \code{\link[SimCorrMix]{corrvar2}}
    using the method of Higham (2002) and the \code{\link[Matrix]{nearPD}} function.
}
\references{
Barbiero A, Ferrari PA (2015). Simulation of correlated Poisson variables. Applied Stochastic Models
    in Business and Industry, 31:669-80. \doi{10.1002/asmb.2072}.

Barbiero A, Ferrari PA (2015). GenOrd: Simulation of Discrete Random Variables with Given
    Correlation Matrix and Marginal Distributions. R package version 1.4.0. \cr
    \url{https://CRAN.R-project.org/package=GenOrd}

Ferrari PA, Barbiero A (2012). Simulating ordinal data, Multivariate Behavioral Research, 47(4):566-589. \doi{10.1080/00273171.2012.692630}.
}
\seealso{
\code{\link[SimCorrMix]{corrvar}}, \code{\link[SimCorrMix]{corrvar2}}, \code{\link[SimCorrMix]{norm_ord}},
         \code{\link[SimCorrMix]{intercorr}}, \code{\link[SimCorrMix]{intercorr2}}
}
\keyword{correlation}
\keyword{ordinal}
