% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_sel.continue.R
\name{coef_sel.continue}
\alias{coef_sel.continue}
\title{Selection coefficient computation}
\usage{
coef_sel.continue(i_fun,E_res,A_fun,delta_fun,correl_fun,beta_fun=NULL)
}
\arguments{
\item{i_fun}{Integer number indicating the enzyme targeted by the mutation. \emph{See details}}

\item{E_res}{Numeric vector of resident enzyme concentrations}

\item{A_fun}{Numeric vector of activities}

\item{delta_fun}{Numeric. Actual effect of a mutation targeting enzyme \code{i_fun}, i.e. \eqn{\delta_i}. \emph{See details}}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{beta_fun}{Matrix of co-regulation coefficients}
}
\value{
Numeric value of the selection coefficient for the target enzyme.

If \code{i_fun} is set to 0, returns the numeric vector of the selection coefficients for the different enzyme.
}
\description{
Computes the selection coefficient using the continuous expression \eqn{s_i = R_i*\delta_i/E_i}
}
\details{
Computes the selection coefficient using a continuous expression \eqn{s_i = R_i*\delta_i/E_i}
    
Only mutations of concentrations are been considered.

\code{i_fun} is the number of the enzyme targeted by the mutation. It is an integer number between 0 and \code{n}, which is the total number of enzyme in the pathway.
If \code{i_fun} is between 1 and \code{n}, \code{delta_fun} needs to be a single value and function \code{coef_sel.continue} computes the selection coefficient of a mutation of actual effect \code{delta_fun} targeting \code{i_fun}.
If \code{i_fun} is set to 0, \code{delta_fun} needs to be a vector of same length as \code{E_res}. Each value of \code{delta_fun} is the actual effect of the mutation, and the position of this value in the vector is the target enzyme number.
Thus, to see the effect of a mutation of given actual effect on every enzyme, set \code{i_fun} to 0 and \code{delta_fun} has to be a vector of same length as \code{E_res}.
}
\examples{

#### Set
A <- c(1,10,30)
E <- c(30,30,30)
correl <- "CRPos"
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
B <- apply(beta,1,sumbis)

### Mutation
mu <- 1
i <- 3
delta <- compute.delta(mu,E,correl,B)

#for enzyme i
coef_sel.continue(i,E,A,delta[i],correl,beta)

#for all enzyme
coef_sel.continue(0,E,A,delta,correl,beta)


}
\references{
Coton et al. (2021)
}
\seealso{
Use function \code{\link{activities}} to compute enzyme activities.
}
