% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul.evol.graph.methods.R
\name{simul.evol.graph.methods}
\alias{simul.evol.graph.methods}
\alias{graph.simul.by.time.by.sim}
\alias{graph.simul.by.time.by.enz}
\alias{graph.simul.others.by.sim}
\alias{graph.simul.by.time.RNV}
\alias{graph.simul.group}
\title{Graphic methods for simulations of enzyme evolution}
\usage{
graph.simul.by.time.by.sim(all_res_sim,new.window=FALSE,add.eq=TRUE,which.sim=NULL,
gr.J.time=FALSE,gr.e.time=TRUE,gr.E.time=FALSE,gr.Etot.time=FALSE,
gr.kin.time=FALSE,gr.A.time=FALSE,gr.tau.time=FALSE,
lwd.eq=1.5,...)

graph.simul.by.time.by.enz(all_res_sim,new.window=FALSE,add.eq=TRUE,which.sim=NULL,
gr.J.time=TRUE,gr.e.time=TRUE,gr.E.time=FALSE,gr.Etot.time=FALSE,
gr.kin.time=FALSE,gr.A.time=FALSE,gr.tau.time=FALSE,
gr.rep.time=FALSE,gr.sim.heading=FALSE,lwd.eq=1.5,...)

graph.simul.others.by.sim(all_res_sim,new.window=FALSE,add.eq=TRUE,which.sim=NULL,
gr.Ef.E0=FALSE, gr.Af.A0=FALSE, gr.Ef.Af=FALSE, gr.J.A.E=TRUE,
gr.J.e=FALSE, gr.J.E=FALSE, env.curve=FALSE, gr.J.A=FALSE, ...)

graph.simul.by.time.RNV(all_res_sim,new.window=FALSE,add.eq=TRUE,which.sim=NULL,
gr.RNV.E=TRUE,gr.RNV.size=FALSE,gr.RNV.delta=FALSE,
gr.RNV.J=FALSE,zoom.RNV.J=NULL,gr.sim.heading=FALSE,
col_RNV=c("grey60","grey80"),lty_RNV=c("dashed","longdash"),lwd.eq=1.5,...)

graph.simul.group(all_res_sim,new.window=FALSE,add.eq=TRUE,which.sim=NULL,which.grp=NULL,
gr.eiq.time=TRUE,gr.eq.time=TRUE,gr.ei.time=FALSE,gr.Eq.time=FALSE,gr.Ei.time=FALSE,
gr.tauq.time=FALSE,lwd.eq=1.5,...)
}
\arguments{
\item{all_res_sim}{List, the output of function \code{\link{simul.evol.enz.multiple}} (results of evolution simulation).}

\item{new.window}{Logical. Do graphics appear in a new window?}

\item{add.eq}{Logical. Do equilibrium appear on graph?}

\item{which.sim}{Numeric vector containing integer numbers between 1 and \code{nsim}. Which simulations would you represent? If \code{NULL} (default), all simulations would be represented.}

\item{gr.J.time, gr.e.time, gr.E.time, gr.Etot.time, gr.kin.time, gr.A.time}{Logical.
Add graph flux \code{J} / relative concentrations \code{e} / absolute concentrations \code{E} / total concentration \code{Etot} / 
kinetic parameters \code{kin} / activities \code{A} in relation to time?}

\item{gr.tau.time}{Logical. Add graph depending on driving variable \eqn{\tau} if exists?}

\item{lwd.eq}{Numeric. Line width for equilibrium line only.}

\item{...}{Arguments to be passed in \code{plot} function, such as \code{lwd} or \code{cex}.}

\item{gr.rep.time}{Logical. Add graph response coefficients in relation to time?}

\item{gr.sim.heading}{Logical. Add an heading before each series of graphics corresponding to current simulation?}

\item{gr.Ef.E0}{Logical. Add graph of final concentrations (absolute E and relative e) depending its initial value?}

\item{gr.Af.A0}{Logical. Add graph of final activities (resp. kinetic parameters) depending its initial value?}

\item{gr.Ef.Af}{Logical. Add graph of final concentrations (absolute E and relative e) depending on final activities A?}

\item{gr.J.A.E}{Logical. Add 3D-graph of flux J depending on concentrations E and activities A?}

\item{gr.J.e}{Logical. Add graph of flux J depending on \emph{relative} concentrations e?}

\item{gr.J.E}{Logical. Add graph of flux J depending on \emph{absolute} concentrations E?}

\item{env.curve}{Logical. Add envelope curve of competition dome? Available only for \code{gr.J.E=T} or \code{gr.J.e=T}.}

\item{gr.J.A}{Logical. Add graph of of flux J depending on activities A?}

\item{gr.RNV.E, gr.RNV.size, gr.RNV.delta}{Logical. Add graph concentrations \code{E} with its RNV / RNV size and RNV size divided by Etot / apparent mutation effect \code{delta} corresponding to RNV in relation to time?}

\item{gr.RNV.J}{Logical. Add graph of flux depending on time and depending on concentrations with RNV and neutral zone?}

\item{zoom.RNV.J}{Numeric vector of length 2, corresponding to \code{ylim} of graphics flux with RNV. If \code{NULL} (by default), \code{ylim} is zoomed around maximal flux of current simulation.
If it is nor \code{NULL} nor vector of length 2, there is no zoom on flux.}

\item{col_RNV, lty_RNV}{Vector of length 2, for color (resp. lty, see plot function) of RNV lines. First element correspond to inferior bounds and second one to superior bounds of RNV.}

\item{which.grp}{Numeric vector containing integer numbers between 1 and \eqn{p} (number of regulation groups). Which regulation groups would you represent? If \code{NULL} (default), all groups would be represented.}

\item{gr.eiq.time, gr.eq.time, gr.ei.time, gr.Eq.time, gr.Ei.time, gr.tauq.time}{Logical.
Add graph intra-group relative concentrations \eqn{e_i^q} / inter-group relative concentrations \eqn{e^q} / total relative concentrations \eqn{e_i} / 
group absolute concentrations \eqn{E^q} / absolute concentrations \eqn{E_i} / group driving variable \eqn{\tau^q} in relation to time?}
}
\value{
Function \code{graph.simul.by.time.by.sim} returns invisible list of 5 elements:
\itemize{
   \item \code{$eq_th_e}: Numeric matrix of \code{n} columns and \code{nsim} rows. Every row corresponds to relative concentrations at theoretical equilibrium computed from initial values of current simulation;
   \item \code{$eq_th_r}: Same structure, for response coefficients at theoretical equilibrium;
   \item \code{$eq_eff_e}: Same structure, for relative concentrations at effective equilibrium (if exists), else \code{NA};
   \item \code{$eq_eff_E}: Same structure, for absolute concentrations at effective equilibrium (if exists), else \code{NA};
   \item \code{$eq_eff_tau}: Numeric matrix of one \code{column} and \code{nsim} rows, corresponding to driving variable \eqn{\tau} at effective equilibrium in case of regulation, else \code{NULL}.
}

Function \code{graph.simul.by.time.by.enz} returns nothing.

Function \code{graph.simul.others.by.sim} returns nothing.

Function \code{graph.simul.by.time.RNV} returns invisible list of 2 elements:
\itemize{
   \item \code{$RNV_all_sim}: List of \code{nsim} elements (which is number of simulation). Every element is the output of function \code{\link{RNV.for.simul}} for corresponding simulation.
   If simulation \emph{i} is not contained in \code{which.sim}, \code{$RNV_all_sim[[i]]} is \code{NULL}. 
   \item \code{$RNV_mean_size}: Numeric matrix of \code{n+2} columns. Row number is between \code{nsim} and \code{2*nsim}, depending on applied constraint.
   \code{n} first columns correspond to RNV mean size for corresponding enzyme for last half simulation; column \code{n+1} indicates simulation number and column \code{n+2} RNV number (between 1 and 2).
}

Function \code{graph.simul.group} returns an invisible list of \code{nsim} elements.
Each element contains the output of \code{\link{predict_grp}}, which computes the equilibria, for the corresponding simulation.
}
\description{
Graphics illustrating enzyme evolution simulations obtained by function \code{\link{simul.evol.enz.multiple}}.

Function \code{graph.simul.by.time.by.sim} gives graphics depending on time, colored by simulations.

Function \code{graph.simul.by.time.by.enz} gives graphics depending on time, colored by enzymes, with series of graphics for each simulation.

Function \code{graph.simul.others.by.sim} gives different graphics depending on other variables than time in x-axis.

Function \code{graph.simul.by.time.RNV} gives graphics of \emph{Range of Neutral Variation} (RNV) for each enzyme.

Function \code{graph.simul.group} gives graphics depending on time, colored by simulations, specifically for regulation groups.
}
\details{
\emph{If only one simulation may be represented, use preferably function \code{graph.simul.by.time.by.enz}.}

Colors for simulations are taken in palette \code{rainbow}.
Colors for enzymes correspond to their number plus one.

\bold{Function \code{graph.simul.by.time.by.sim}} gives graphs of flux, relative concentrations, absolute concentrations, total concentration, kinetic parameters and activities through time.
In addition, if all enzymes are co-regulated, gives also driving variable \eqn{\tau} in relation to time.
\emph{Lines are colored according to simulation.} There is one graph by enzyme if necessary.
Dashed lines correspond to theoretical equilibrium, and dotted lines to effective equilibrium.
Every graph follow same scheme:
\enumerate{
   \item empty graph with time in x-axis and interesting variable in y-axis
   \item for each simulation \emph{i}
   \item add connected points for current variable for simulation \emph{i}
   \item add text for simulation number \emph{i} at end of x-axis
   \item eventually, add predicted values
}


\bold{Function \code{graph.simul.by.time.by.enz}} gives graphs of flux, relative concentrations, absolute concentrations, total concentration, kinetic parameters, activities and response coefficients through time. 
In addition, if all enzymes are co-regulated, gives also driving variable \eqn{\tau} in relation to time and flux in relation to \eqn{\tau}.
\emph{Lines are colored according to enzyme.} There is one graph by simulation. An heading with parameters of current simulation can be added with \code{gr.sim.heading}
Dashed lines correspond to theoretical equilibrium, and dotted lines to effective equilibrium.
\enumerate{
   \item for each simulation \emph{i}
   \item line graph with time in x-axis and interesting variable in y-axis
   \item eventually, add predicted values
   \item add legend
}


\bold{Function \code{graph.simul.others.by.sim}} gives graphs of:
\itemize{
   \item final concentrations in relation to initial concentrations
   \item final relative concentrations in relation to initial relative concentrations
   \item final kinetic parameters in relation to initial kinetic parameters
   \item final activities in relation to initial activities
   \item final concentrations in relation to final activities
   \item final relative concentrations in relation to final activities
   \item flux in relation to concentrations and activities (3D-graph)
   \item flux in relation to absolute or relative concentrations (one graph by enzyme, colored by simulation)
}
One color by enzyme. The colored numbers correspond to the simulations.


\bold{Function \code{graph.simul.by.time.RNV}} gives graphs of, for each simulations:
\itemize{
   \item concentrations with RNV bounds
   \item apparent mutation effects \eqn{\delta} at RNV bounds, for each enzyme considering at mutant
   \item RNV size
   \item RNV size divided by total concentration
   \item flux with neutral zone bounds, in relation to time and in relation to enzyme concentrations of each enzyme (where data are ordered to facilitate view)
}
Lines are colored by enzymes. Bounds of RNV is colored depending on \code{col_RNV}.


#' \bold{Function \code{graph.simul.group}} gives graphs of:
\itemize{
   \item intra-group relative concentrations \eqn{e_i^q}
   \item inter-group relative concentrations \eqn{e^q}
   \item total relative concentrations \eqn{e_i} (same as \code{gr.e.time} in \code{graoh.simul.by.time.by.sim})
   \item absolute concentrations for a group \eqn{E^q}
   \item absolute concentrations \eqn{E_i} (same as \code{gr.E.time} in \code{graoh.simul.by.time.by.sim})
   \item driving variable of group \eqn{\tau^q}
}
Lines are colored by simulations. 


\bold{Graphical parameters}

To modify line width, input both \code{lwd} and \code{lwd.eq}.
Input \code{lwd} without input \code{lwd.eq} modifies only equilibrium line width, and not all line width.

\emph{Envelope curve}

The envelope curve is the projection of competition dome in graph of flux J depending on concentrations (\code{gr.J.E=TRUE} and \code{gr.J.e=TRUE}).
This curve is available only if there is competition, if the total concentration and activities are identical between simulations, and activities are not subject yo mutations.

\emph{col_RNV and lty_RNV}

Vector of length 2, for color (resp. lty, see \code{plot} function) of RNV lines. First element correspond to inferior bounds and second one to superior bounds of RNV.

These parameters are only available for plot \code{gr.RNV.E} and \code{gr.RNV.J}.
}
\examples{
 
  # With saved simulation
data(data_sim_RegNeg)

graph.simul.by.time.by.sim(data_sim_RegNeg,new.window=TRUE)
graph.simul.by.time.by.enz(data_sim_RegNeg,new.window=TRUE,which.sim=c(1))
graph.simul.others.by.sim(data_sim_RegNeg,new.window=TRUE,env.curve=TRUE,gr.J.E)
graph.simul.by.time.RNV(data_sim_RegNeg,new.window=TRUE,which.sim=c(1))

data(data_sim_CRNeg_1grpNeg1sgl)
graph.simul.group(data_sim_CRNeg_1grpNeg1sgl,gr.Eq.time=TRUE,gr.tauq.time=TRUE)
 
 
 
 \donttest{
 #New simulation
# case for 3 enzymes
n <- 3
E0 <- c(30,30,30)
kin <- c(1,10,30)
Keq <- c(1,1,1)
nsim <- 2 # 2 simulations
N <- 1000
beta <- diag(1,n)
beta[upper.tri(beta)] <- c(0.32,0.32*(-0.43),-0.43)
#put : beta_12 = 0.32, beta_13 = beta_12 x beta_23, beta_23 = -0.43
t_beta <- t(beta) #because R fills matrix column by column
beta[lower.tri(beta)] <- 1/t_beta[lower.tri(t_beta)] #beta_ji = 1/beta_ij
if (n==3) {beta[lower.tri(beta)] <- 1/beta[upper.tri(beta)]} #only available if n=3
correl <- "RegNeg"

evol_sim <- simul.evol.enz.multiple(E0,kin,Keq,nsim,N,correl,beta,npt=250)
graph.simul.by.time.by.sim(evol_sim,new.window=TRUE)
graph.simul.by.time.by.enz(evol_sim,new.window=TRUE,which.sim=c(1))
graph.simul.others.by.sim(evol_sim,new.window=TRUE)
graph.simul.by.time.RNV(evol_sim,new.window=TRUE,which.sim=c(1))

}






}
\seealso{
Use function \code{\link{simul.evol.enz.multiple}} to simulate enzyme evolution.

Function \code{\link[scatterplot3d]{scatterplot3d}} is used to make the 3D-graph in function \code{graph.simul.others.by.sim}.
}
