% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Celltype_annotation_PanglaoDB.R
\name{Celltype_annotation_PanglaoDB}
\alias{Celltype_annotation_PanglaoDB}
\title{Uses "marker_list" from PanglaoDB for cell annotation}
\usage{
Celltype_annotation_PanglaoDB(
  seurat_obj,
  gene_list,
  species,
  cluster_col = "seurat_clusters",
  assay = "RNA",
  save_path = NULL,
  metric_names = NULL,
  colour_low = "white",
  colour_high = "navy",
  colour_low_mertic = "white",
  colour_high_mertic = "navy"
)
}
\arguments{
\item{seurat_obj}{Enter the Seurat object with annotation columns such as
"seurat_cluster" in meta.data to be annotated.}

\item{gene_list}{Enter the standard "Marker_list" generated by the PanglaoDB
database for the SlimR package, generated by the "Markers_filter_PanglaoDB ()"
function.}

\item{species}{This parameter selects the species "Human" or "Mouse" for standard
gene format correction of markers entered by "Marker_list".}

\item{cluster_col}{Enter annotation columns such as "seurat_cluster" in meta.data
of the Seurat object to be annotated. Default parameters use "cluster_col =
'seurat_clusters'".}

\item{assay}{Enter the assay used by the Seurat object, such as "RNA". Default
parameters use "assay = 'RNA'".}

\item{save_path}{The output path of the cell annotation picture. Example parameters
use "save_path = './SlimR/Celltype_annotation_PanglaoDB/'".}

\item{metric_names}{Warning: Do not enter information. This parameter is used to
check if "Marker_list" conforms to the PanglaoDB database output.}

\item{colour_low}{Color for lowest expression level. (default = "white")}

\item{colour_high}{Color for highest expression level. (default = "black")}

\item{colour_low_mertic}{Color for lowest mertic level. (default = "white")}

\item{colour_high_mertic}{Color for highest mertic level. (default = "black")}
}
\value{
The cell annotation picture is saved in "save_path".
}
\description{
Uses "marker_list" from PanglaoDB for cell annotation
}
\examples{
\dontrun{
Celltype_annotation_PanglaoDB(seurat_obj = sce,
    gene_list = Markers_list_panglaoDB,
    species = "Human",
    cluster_col = "seurat_clusters",
    assay = "RNA",
    save_path = file.path(tempdir(),"SlimR_Celltype_annotation_PanglaoDB")
    colour_low = "white",
    colour_high = "navy",
    colour_low_mertic = "white",
    colour_high_mertic = "navy",
    )
    }

}
\seealso{
Other Other_Functions_Provided_By_SlimR: 
\code{\link{Celltype_annotation_Cellmarker2}()},
\code{\link{Celltype_annotation_Excel}()},
\code{\link{Celltype_annotation_Seurat}()}
}
\concept{Other_Functions_Provided_By_SlimR}
