% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_exp_categorical.R
\name{ExpCatStat}
\alias{ExpCatStat}
\title{Function provides summary statistics for all character or categorical columns in the dataframe}
\usage{
ExpCatStat(data,Target=NULL,Label=NULL,result=c("Stat","IV"),clim=10,nlim=10,Pclass=NULL)
}
\arguments{
\item{data}{dataframe or matrix}

\item{Target}{target variable}

\item{Label}{target variable label (not mandatory)}

\item{result}{"Stat" - summary statistics, "IV" - information value}

\item{clim}{maximum unique levles for categorical variable. Variables will be dropped if unique levels is higher than clim for class factor/character variable}

\item{nlim}{maximum unique values for numeric variable.}

\item{Pclass}{reference category of target variable}
}
\value{
This function provides summary statistics for categorical variable

Stat-Summary statistics includes Chi square test scores, p value, Information values, Cramers V and Degree if association

IV- Weight of evidence and Information values

Columns description:

 •	Variable – variable name

 •	Target -  Target variable label

 •	class – name of bin (variable value otherwise)

 •	out0 – number of good observations

 •	out1 – number of bad observations

 •	Total – Total values for each category

 •	pct1 – good observations / total good observations

 •	pct0 – bad observations / total bad observations

 •	odds – pct1/pct0

 •	woe – Weight of Evidence – calculated as ln(odds)

 •	iv – Information Value  - ln(odds) * (pct0 – pct1)
}
\description{
This function combines results from weight of evidence, information value and summary statistics.
}
\details{
Criteria used for categorical variable predictive power classification are

If information value is < 0.03 then predictive power = "Not Predictive"

If information value is 0.3 to 0.1 then predictive power = "Somewhat Predictive"

If information value is 0.1 to 0.3 then predictive power = "Meidum Predictive"

If information value is >0.3 then predictive power = "Highly Predictive"
}
\examples{
# Example 1
## Read mtcars data
# Target variable "am" - Transmission (0 = automatic, 1 = manual)
# Summary statistics
ExpCatStat(mtcars,Target="am",Label="Transmission",result = "Stat",clim=10,nlim=5,Pclass=1)
# Inforamtion value for categorical Independent variables
ExpCatStat(mtcars,Target="am",Label="Transmission",result = "IV",clim=10,nlim=5,Pclass=1)
}
\author{
dubrangala
}
