% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_rate_fun.R
\name{st_rate}
\alias{st_rate}
\title{Standardized mortality rates and confidence intervals}
\usage{
st_rate(
  data,
  health,
  population,
  ses,
  age,
  groups = NULL,
  age_group = NULL,
  st_pop = "esp2013_18ag",
  CI = 95,
  total = 1000
)
}
\arguments{
\item{data}{Name of data set.}

\item{health}{Health outcome of interest.}

\item{population}{Population counts. Should correspond to data provided in \code{health}.}

\item{ses}{Categorical deprivation measure used for splitting the data.}

\item{age}{Variable that defines 5-year age groups, should be ordered and numeric, such as 1 through 18.
If the age group coding starts with 0 it will be assumed that age groups 0 and 1-4 are separate.
If the age group starts with 1, it will be assumed that the first age group is 0-4 (ages 0 and 1-4 are combined).}

\item{groups}{Conditions such as sex or ethnicity that together define the sub-population for which the
rates are calculated for. Default is \code{NULL}, no sub-population is selected.}

\item{age_group}{The age groups the standardized rates should be calculated for. By default the function calculates
results for the following age groups: 0-14, 15-29, 30-44, 45-59, 60-74, 75+, 0-64 and all ages.
User supplied age groups should be provided using the standard population groups as cut-offs, e.g. use
\code{age_group=c("20-29", "30-39")} and not \code{c("19-30", "31-41")}. Open ended age groups can be supplied by giving
a single age, e.g. "45" means 45 and above. Overlapping age groups, such as \code{c("20-29", "25-34")}, are not supported.
Results for ages 0-64 and all ages will always be provided.}

\item{st_pop}{The standard population weights used for calculating rates, default 2013 ESP for 18 age groups with 0-4 as
the first age group. See \code{\link{st_pop}} for other predefined options. Can be user supplied, but must match
the number of age groups given in \code{age} and add up to 1.}

\item{CI}{Confidence intervals, 95 by default but can be set to any number between 0 and 100.}

\item{total}{The total number of people in the standard population, i.e. are rates be calculated per 1000 or 100 000, default 1000}
}
\value{
A data frame giving standardized rates by age group and deprivation together with CI.
}
\description{
\code{st_rate} calculates direct standardized mortality rates and the 95\% or 99\% confidence intervals.
  Default standardization uses the 2013 European Standard Population, but other built-in or user supplied
  weights can also be supplied.
}
\examples{
d <- health_data

# Standardized rates for all people
st_rate(d, bad, pop, quintile, age, ethnicity == "all")

# Or save results
rate_data <- st_rate(d, bad, pop, quintile, age, ethnicity == "all")
# Then use View(rate_data) to view results

# Standardized rates for Scottish, with 99\% CI
st_rate(d, bad, pop, quintile, age, ethnicity == "Scot", age_group = c("15-29", "30-44"), CI = 99)

}
