% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CN_input_amendments.R
\name{CN_input_amendments}
\alias{CN_input_amendments}
\title{Estimate C and N inputs of organic amendments}
\usage{
CN_input_amendments(
  amount,
  amd_type = NA,
  DMC = NA,
  C_content = NA,
  N_content = NA,
  return.comment = FALSE,
  concentration_liquids = 0.5
)
}
\arguments{
\item{amount}{Amount of organic amendment in fresh weight (t/ha)}

\item{amd_type}{Type of organic manure, there are default values available for
"Slurry_dairy_cow", "Manure_dairy_cow", "Slurry_cattle", "Manure_cattle", "Slurry_pig",
"Manure_pig", "Compost", "Biorga_Quick_12N" and others (see \code{CN_input_amendments_LUT})}

\item{DMC}{dry matter content of the organic amendment (gDM/kgFM)}

\item{C_content}{C content of the dry matter (gC/kgDM)}

\item{N_content}{N content of the dry matter (gN/kgDM)}

\item{return.comment}{(optional): logical value if comments are returned or not. Default = FALSE}

\item{concentration_liquids}{concentration factor for liquid amendments. Default value is .5.}
}
\value{
a tibble with the following parameters:
\itemize{
\item C_input_org: C input by organic ammendment (kgC/ha)
\item N_input_org: N input by organic ammendment (kgN/ha)
\item comment (optional): Source of information on properties of organic amendment
}
}
\description{
Estimates the carbon (C) and total nitrogen (N) input into
the soil system by organic amendments.
}
\details{
The C and N inputs by organic amendments is calculated based on the
dry matter content (DMC) and the C and N content of the dry matter
of the amendment. If the contents are not specified,
default values from the Swiss fertilizer recommendations
\insertCite{GRUD2017_ch8}{SoilManageR} are assumed.
The default values are available the look-up-table \code{CN_input_amendments_LUT}
For all slurries and liquid amendments (DMC < 150 g/kg), a dilution of 50\% is
assumed if default DMC values from the \code{CN_input_amendments_LUT} are used.
}
\examples{
#example where amount, dry matter content, C and N content are known.
CN_input_amendments(40, DMC = 300, C_content = 300, N_content = 30)

#example where only amount and type of amendment are known 
CN_input_amendments(20, "Manure_pig")

#example of a diluted slurry
CN_input_amendments(20, amd_type = "Slurry_dairy_cow", DMC = 50)


}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item \code{\link[=C_input]{C_input()}} to calculate C inputs for a management_df
\item \code{\link[=N_input]{N_input()}} to calculate N inputs for a management_df
\item \code{\link[=C_input_crops]{C_input_crops()}} to calculate C inputs by crops
\item \code{\link[=C_input_cover_crops]{C_input_cover_crops()}} to calculate C input for cover crops
\item \code{\link[=CN_input_amendments_LUT]{CN_input_amendments_LUT()}} for the look-up-table for organic amendments reference values
}
}
