% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{STIR_values_LUT}
\alias{STIR_values_LUT}
\title{Look-up-table with default values for tillage operations}
\format{
A tibble with 50 rows and 15 columns:
\describe{
  \item{Operation}{Name of the operation}
  \item{Speed}{Average speed of the operation	[km/h]}
  \item{Speed_MIN}{Min speed of the operation	[km/h]}
  \item{Speed_Max}{Max speed of the operation	[km/h]}
  \item{Surf_Disturbance}{Share of the disturbed soil surface	[\%]}
  \item{Depth}{Average depth of the operation	[cm]}
  \item{Depth_MIN}{Min depth of the operation	[cm]}
  \item{Depth_MAX}{Max depth of the operation	[cm]}
  \item{TILLAGE_TYPE}{Type of tillage operation}
  \item{TILLAGE_TYPE_Modifier}{Numerical value of the tillage type modifier	[0-1]}
  \item{STIR}{Soil tillage intensity rating value, based on default values}
  \item{Diesel_use}{iesel use of the operation per area	[l/ha]}
  \item{Burial_Coefficient}{Burial of plant residues on the soil surface	[0-1]}
  \item{Source}{Source of the values in the table}
  \item{Description}{Description of the operation}
}
}
\usage{
STIR_values_LUT
}
\description{
The dataset is a look-up-table that is used to derive STIR values with the 
 function `SoilManageR::STIR()` and residue incorperation by
 tillage operations with the function `SoilManageR::soil_cover()`.
 The data set is produced from the excel table `STIR_value_LUT.xlsx` file 
 under `/inst/extdata/` and was mostly derived from the official 
 RUSLE2 database \insertCite{RUSLE2}{SoilManageR}.
}
\references{
\insertAllCited{}
}
\keyword{datasets}
