% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_bouts_info.R
\name{compute.bouts.info}
\alias{compute.bouts.info}
\title{Summarize outcomes from data processed using the Sojourn method}
\usage{
compute.bouts.info(est.mets, units = c("secs", "mins"))
}
\arguments{
\item{est.mets}{numeric vector of predicted metabolic equivalents}

\item{units}{time units associated with each row of data}
}
\value{
a data frame summarizing the predictions made by the Sojourn method.
}
\description{
A function to summarize predictions made by the original Sojourn method of
\href{https://pubmed.ncbi.nlm.nih.gov/23860415/}{Lyden et al. (2014)}.
}
\examples{
data(example_data, package = "Sojourn")
if (isTRUE(requireNamespace("Sojourn.Data"))) {
example_data <-
  soj_3x_original(
    example_data$axis1,
    example_data$axis2,
    example_data$axis3,
    example_data$Vector.Magnitude
  )

compute.bouts.info(example_data$METs)
}
}
