% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadAdatsAsList.R
\name{loadAdatsAsList}
\alias{loadAdatsAsList}
\alias{collapseAdats}
\title{Load ADAT files as a list}
\usage{
loadAdatsAsList(files, collapse = FALSE, verbose = interactive(), ...)

collapseAdats(x)
}
\arguments{
\item{files}{A character string of files to load.}

\item{collapse}{Logical. Should the resulting list of ADATs be
collapsed into a single ADAT object?}

\item{verbose}{Logical. Should the function call be run in \emph{verbose} mode.}

\item{...}{Additional arguments passed to \code{\link[=read_adat]{read_adat()}}.}

\item{x}{A list of \code{soma_adat} class objects returned from
\code{\link[=loadAdatsAsList]{loadAdatsAsList()}}.}
}
\value{
A list of ADATs named by \code{files}, each a \code{soma_adat} object
corresponding to an individual file in \code{files}. For \code{\link[=collapseAdats]{collapseAdats()}},
a single, collapsed \code{soma_adat} object.
}
\description{
Load a series of ADATs and return a list of \code{soma_adat}
objects, one for each ADAT file.
\code{\link[=collapseAdats]{collapseAdats()}} concatenates a list of ADATs from \code{\link[=loadAdatsAsList]{loadAdatsAsList()}},
while maintaining the relevant attribute entries (mainly the \code{HEADER}
element). This makes writing out the final object possible without the
loss of \code{HEADER} information.
}
\details{
\describe{
\item{\strong{Note 1}:}{The default behavior is to "vertically bind"
(\code{\link[=rbind]{rbind()}}) on the  \emph{intersect} of the column variables, with
unique columns silently dropped.}
\item{\strong{Note 2}:}{If "vertically binding" on the column \emph{union} is
desired, use \code{\link[=bind_rows]{bind_rows()}}, however this results in \code{NAs} in
non-intersecting columns. For many files with little variable
intersection, a sparse RFU-matrix will result
(and will likely break ADAT attributes):

\if{html}{\out{<div class="sourceCode r">}}\preformatted{adats <- loadAdatsAsList(files)
union_adat <- dplyr::bind_rows(adats, .id = "SourceFile")
}\if{html}{\out{</div>}}

}
}
}
\examples{
# only 1 file in directory
dir(system.file("extdata", package = "SomaDataIO"))

files <- system.file("extdata", package = "SomaDataIO") |>
  dir(pattern = "[.]adat$", full.names = TRUE) |> rev()

adats <- loadAdatsAsList(files)
class(adats)

# collapse into 1 ADAT
collapsed <- collapseAdats(adats)
class(collapsed)

\donttest{
# Alternatively use `collapse = TRUE`
loadAdatsAsList(files, collapse = TRUE)
}
}
\seealso{
\code{\link[=read_adat]{read_adat()}}

Other IO: 
\code{\link{parseHeader}()},
\code{\link{read_adat}()},
\code{\link{soma_adat}},
\code{\link{write_adat}()}
}
\author{
Stu Field
}
\concept{IO}
