% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{.modifySearchPath}
\alias{.modifySearchPath}
\title{Modify package order in search path}
\usage{
.modifySearchPath(pkgs, removeOthers = FALSE)
}
\arguments{
\item{pkgs}{The packages that are to be placed at the beginning of the search path,}

\item{removeOthers}{Logical. If \code{TRUE}, then only the packages in \code{pkgs}
will remain in the search path, i.e., all others will be removed.}
}
\value{
Nothing. This is used for its side effects, which are "severe".
}
\description{
Intended for internal use only. It modifies the search path (i.e., \code{search()})
such that the packages required by the current module are placed first in the
search path. Note, several "core" packages are not touched; or more specifically,
they will remain in the search path, but may move down if packages are rearranged.
The current set of these core packages used by SpaDES can be found here:
\code{SpaDES.core:::.pkgEnv$corePackages}
}
\author{
Eliot McIntire
}
\keyword{internal}
