% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R, R/functions.R
\docType{methods}
\name{coalesce}
\alias{coalesce}
\alias{coalesce}
\alias{coalesce,SparkDataFrame-method}
\alias{coalesce}
\alias{coalesce,Column-method}
\title{Coalesce}
\usage{
coalesce(x, ...)

\S4method{coalesce}{SparkDataFrame}(x, numPartitions)

\S4method{coalesce}{Column}(x, ...)
}
\arguments{
\item{x}{a Column or a SparkDataFrame.}

\item{...}{additional argument(s). If \code{x} is a Column, additional Columns can be optionally
provided.}

\item{numPartitions}{the number of partitions to use.}
}
\description{
Returns a new SparkDataFrame that has exactly \code{numPartitions} partitions.
This operation results in a narrow dependency, e.g. if you go from 1000 partitions to 100
partitions, there will not be a shuffle, instead each of the 100 new partitions will claim 10 of
the current partitions. If a larger number of partitions is requested, it will stay at the
current number of partitions.

Returns the first column that is not NA, or NA if all inputs are.
}
\details{
However, if you're doing a drastic coalesce on a SparkDataFrame, e.g. to numPartitions = 1,
this may result in your computation taking place on fewer nodes than
you like (e.g. one node in the case of numPartitions = 1). To avoid this,
call \code{repartition}. This will add a shuffle step, but means the
current upstream partitions will be executed in parallel (per whatever
the current partitioning is).
}
\note{
coalesce(SparkDataFrame) since 2.1.1

coalesce(Column) since 2.1.1
}
\examples{
\dontrun{
sparkR.session()
path <- "path/to/file.json"
df <- read.json(path)
newDF <- coalesce(df, 1L)
}
\dontrun{coalesce(df$c, df$d, df$e)}
}
\seealso{
\link{repartition}

Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{arrange}},
  \code{\link{as.data.frame}}, \code{\link{attach}},
  \code{\link{cache}}, \code{\link{collect}},
  \code{\link{colnames}}, \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{dapplyCollect}},
  \code{\link{dapply}}, \code{\link{describe}},
  \code{\link{dim}}, \code{\link{distinct}},
  \code{\link{dropDuplicates}}, \code{\link{dropna}},
  \code{\link{drop}}, \code{\link{dtypes}},
  \code{\link{except}}, \code{\link{explain}},
  \code{\link{filter}}, \code{\link{first}},
  \code{\link{gapplyCollect}}, \code{\link{gapply}},
  \code{\link{getNumPartitions}}, \code{\link{group_by}},
  \code{\link{head}}, \code{\link{histogram}},
  \code{\link{insertInto}}, \code{\link{intersect}},
  \code{\link{isLocal}}, \code{\link{join}},
  \code{\link{limit}}, \code{\link{merge}},
  \code{\link{mutate}}, \code{\link{ncol}},
  \code{\link{nrow}}, \code{\link{persist}},
  \code{\link{printSchema}}, \code{\link{randomSplit}},
  \code{\link{rbind}}, \code{\link{registerTempTable}},
  \code{\link{rename}}, \code{\link{repartition}},
  \code{\link{sample}}, \code{\link{saveAsTable}},
  \code{\link{schema}}, \code{\link{selectExpr}},
  \code{\link{select}}, \code{\link{showDF}},
  \code{\link{show}}, \code{\link{storageLevel}},
  \code{\link{str}}, \code{\link{subset}},
  \code{\link{take}}, \code{\link{union}},
  \code{\link{unpersist}}, \code{\link{withColumn}},
  \code{\link{with}}, \code{\link{write.df}},
  \code{\link{write.jdbc}}, \code{\link{write.json}},
  \code{\link{write.orc}}, \code{\link{write.parquet}},
  \code{\link{write.text}}

Other normal_funcs: \code{\link{abs}},
  \code{\link{bitwiseNOT}}, \code{\link{column}},
  \code{\link{expr}}, \code{\link{greatest}},
  \code{\link{ifelse}}, \code{\link{isnan}},
  \code{\link{least}}, \code{\link{lit}},
  \code{\link{nanvl}}, \code{\link{negate}},
  \code{\link{randn}}, \code{\link{rand}},
  \code{\link{struct}}, \code{\link{when}}
}
