% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\docType{methods}
\name{describe}
\alias{describe}
\alias{describe,SparkDataFrame,character-method}
\alias{describe,SparkDataFrame,ANY-method}
\alias{describe,SparkDataFrame-method}
\title{describe}
\usage{
describe(x, col, ...)

\S4method{describe}{SparkDataFrame,character}(x, col, ...)

\S4method{describe}{SparkDataFrame,ANY}(x)
}
\arguments{
\item{x}{a SparkDataFrame to be computed.}

\item{col}{a string of name.}

\item{...}{additional expressions.}
}
\value{
A SparkDataFrame.
}
\description{
Computes statistics for numeric and string columns.
If no columns are given, this function computes statistics for all numerical or string columns.
}
\note{
describe(SparkDataFrame, character) since 1.4.0

describe(SparkDataFrame) since 1.4.0
}
\examples{
\dontrun{
sparkR.session()
path <- "path/to/file.json"
df <- read.json(path)
describe(df)
describe(df, "col1")
describe(df, "col1", "col2")
}
}
\seealso{
See \link{summary} for expanded statistics and control over which statistics to compute.

Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{alias}},
  \code{\link{arrange}}, \code{\link{as.data.frame}},
  \code{\link{attach,SparkDataFrame-method}},
  \code{\link{broadcast}}, \code{\link{cache}},
  \code{\link{checkpoint}}, \code{\link{coalesce}},
  \code{\link{collect}}, \code{\link{colnames}},
  \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{cube}},
  \code{\link{dapplyCollect}}, \code{\link{dapply}},
  \code{\link{dim}}, \code{\link{distinct}},
  \code{\link{dropDuplicates}}, \code{\link{dropna}},
  \code{\link{drop}}, \code{\link{dtypes}},
  \code{\link{exceptAll}}, \code{\link{except}},
  \code{\link{explain}}, \code{\link{filter}},
  \code{\link{first}}, \code{\link{gapplyCollect}},
  \code{\link{gapply}}, \code{\link{getNumPartitions}},
  \code{\link{group_by}}, \code{\link{head}},
  \code{\link{hint}}, \code{\link{histogram}},
  \code{\link{insertInto}}, \code{\link{intersectAll}},
  \code{\link{intersect}}, \code{\link{isLocal}},
  \code{\link{isStreaming}}, \code{\link{join}},
  \code{\link{limit}}, \code{\link{localCheckpoint}},
  \code{\link{merge}}, \code{\link{mutate}},
  \code{\link{ncol}}, \code{\link{nrow}},
  \code{\link{persist}}, \code{\link{printSchema}},
  \code{\link{randomSplit}}, \code{\link{rbind}},
  \code{\link{rename}}, \code{\link{repartitionByRange}},
  \code{\link{repartition}}, \code{\link{rollup}},
  \code{\link{sample}}, \code{\link{saveAsTable}},
  \code{\link{schema}}, \code{\link{selectExpr}},
  \code{\link{select}}, \code{\link{showDF}},
  \code{\link{show}}, \code{\link{storageLevel}},
  \code{\link{str}}, \code{\link{subset}},
  \code{\link{summary}}, \code{\link{take}},
  \code{\link{toJSON}}, \code{\link{unionByName}},
  \code{\link{union}}, \code{\link{unpersist}},
  \code{\link{withColumn}}, \code{\link{withWatermark}},
  \code{\link{with}}, \code{\link{write.df}},
  \code{\link{write.jdbc}}, \code{\link{write.json}},
  \code{\link{write.orc}}, \code{\link{write.parquet}},
  \code{\link{write.stream}}, \code{\link{write.text}}
}
\concept{SparkDataFrame functions}
