% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\docType{methods}
\name{intersectAll}
\alias{intersectAll}
\alias{intersectAll,SparkDataFrame,SparkDataFrame-method}
\title{intersectAll}
\usage{
intersectAll(x, y)

\S4method{intersectAll}{SparkDataFrame,SparkDataFrame}(x, y)
}
\arguments{
\item{x}{a SparkDataFrame.}

\item{y}{a SparkDataFrame.}
}
\value{
A SparkDataFrame containing the result of the intersect all operation.
}
\description{
Return a new SparkDataFrame containing rows in both this SparkDataFrame
and another SparkDataFrame while preserving the duplicates.
This is equivalent to \code{INTERSECT ALL} in SQL. Also as standard in
SQL, this function resolves columns by position (not by name).
}
\note{
intersectAll since 2.4.0
}
\examples{
\dontrun{
sparkR.session()
df1 <- read.json(path)
df2 <- read.json(path2)
intersectAllDF <- intersectAll(df1, df2)
}
}
\seealso{
Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{alias}},
  \code{\link{arrange}}, \code{\link{as.data.frame}},
  \code{\link{attach,SparkDataFrame-method}},
  \code{\link{broadcast}}, \code{\link{cache}},
  \code{\link{checkpoint}}, \code{\link{coalesce}},
  \code{\link{collect}}, \code{\link{colnames}},
  \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{cube}},
  \code{\link{dapplyCollect}}, \code{\link{dapply}},
  \code{\link{describe}}, \code{\link{dim}},
  \code{\link{distinct}}, \code{\link{dropDuplicates}},
  \code{\link{dropna}}, \code{\link{drop}},
  \code{\link{dtypes}}, \code{\link{exceptAll}},
  \code{\link{except}}, \code{\link{explain}},
  \code{\link{filter}}, \code{\link{first}},
  \code{\link{gapplyCollect}}, \code{\link{gapply}},
  \code{\link{getNumPartitions}}, \code{\link{group_by}},
  \code{\link{head}}, \code{\link{hint}},
  \code{\link{histogram}}, \code{\link{insertInto}},
  \code{\link{intersect}}, \code{\link{isLocal}},
  \code{\link{isStreaming}}, \code{\link{join}},
  \code{\link{limit}}, \code{\link{localCheckpoint}},
  \code{\link{merge}}, \code{\link{mutate}},
  \code{\link{ncol}}, \code{\link{nrow}},
  \code{\link{persist}}, \code{\link{printSchema}},
  \code{\link{randomSplit}}, \code{\link{rbind}},
  \code{\link{rename}}, \code{\link{repartitionByRange}},
  \code{\link{repartition}}, \code{\link{rollup}},
  \code{\link{sample}}, \code{\link{saveAsTable}},
  \code{\link{schema}}, \code{\link{selectExpr}},
  \code{\link{select}}, \code{\link{showDF}},
  \code{\link{show}}, \code{\link{storageLevel}},
  \code{\link{str}}, \code{\link{subset}},
  \code{\link{summary}}, \code{\link{take}},
  \code{\link{toJSON}}, \code{\link{unionByName}},
  \code{\link{union}}, \code{\link{unpersist}},
  \code{\link{withColumn}}, \code{\link{withWatermark}},
  \code{\link{with}}, \code{\link{write.df}},
  \code{\link{write.jdbc}}, \code{\link{write.json}},
  \code{\link{write.orc}}, \code{\link{write.parquet}},
  \code{\link{write.stream}}, \code{\link{write.text}}
}
\concept{SparkDataFrame functions}
