% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda2_calcualtor.R
\name{lambda2_calculator}
\alias{lambda2_calculator}
\title{Lambda 2 Calculator.}
\usage{
lambda2_calculator(pdat1, pdat2, ncluster, alpha2 = 0.5, nboot2 = 1000)
}
\arguments{
\item{pdat1}{The centered data from condition 1, columns should be
samples (cells) and rows should be features (genes).}

\item{pdat2}{The centered data from condition 2, columns should be
samples (cells) and rows should be features (genes). The number of genes
should be the same as \code{pdat1}.
as in pdat1.}

\item{ncluster}{The number of clusters present in the data.}

\item{alpha2}{The quantile of the bootstrapped lambda 2 values to use,
range is (0,1). The default value is 0.5, the median of the calculated
lambda 2 values.}

\item{nboot2}{The number of bootstrap repitions for eatimating lambda 2,
the default value is 1000.}
}
\value{
The calculated value of lambda 2 to use in the main SparseDC
algortihm.
}
\description{
Calculates the lambda 2 values for use in the main SparseDC algorithm, the
lambda 2 value controls the number of genes that show condition-dependent
expression within each cell type. That is it controls the number of
different mean values across the conditions for each cluster. It is
calculated by estimating the value of lambda 2 that would result in no
difference in mean values across conditions when there are no meaningful
differences across between the conditions. For further details please see
the original manuscript.
}
\examples{

set.seed(10)
# Select small dataset for example
data_test <- data_biase[1:100,]
# Split data into conditions A and B
data_A <- data_test[ , which(condition_biase == "A")]
data_B <- data_test[ , which(condition_biase == "B")]
# Pre-process the data
pre_data <- pre_proc_data(data_A, data_B, norm = FALSE, log = TRUE,
center = TRUE)
# Calculate the lambda 2 value
lambda2_calculator(pdat1 = pre_data[[1]], pdat2 = pre_data[[2]], ncluster = 3,
 alpha2 = 0.5, nboot2 = 1000)

 # Can also run
 pdata_A <- pre_data[[1]]
 pdata_B <- pre_data[[2]]
lambda2_calculator(pdat1 = pdata_A, pdat2 = pdata_B, ncluster = 3,
 alpha2 = 0.5, nboot2 = 1000)

}
\seealso{
\code{\link{lambda1_calculator}}  \code{\link{sparsedc_cluster}}
}
