% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.R
\name{shannon}
\alias{shannon}
\title{Shannon's entropy.}
\usage{
shannon(data)
}
\arguments{
\item{data}{A data matrix or vector, can be numeric, factor, character, ...
Alternatively, a marked \code{ppp} object.}
}
\value{
a list of three elements:
\itemize{
\item \code{probabilities} - a table with the estimated probabilities (relative frequencies) for all data categories;
\item \code{shann} - Shannon's entropy;
\item \code{rel.shann} - Shannon's relative entropy.
}
}
\description{
This function computes Shannon's entropy of a variable \eqn{X} with a finite number of categories. Shannon's entropy is a non-spatial measure.
}
\details{
Shannon's entropy measures the heterogeneity of a set of categorical data. It
is computed as \deqn{H(X)=\sum p(x_i) \log(1/p(x_i))} where \eqn{p(x_i)} is the
probability of occurrence of the \eqn{i}-th category, here estimated, as usual, by its relative
frequency. This is both the non parametric and the maximum likelihood estimator for entropy.
Shannon's entropy varies between 0 and \eqn{\log(I)}, \eqn{I} being the
number of categories of the variable under study. The relative version of Shannon's entropy, i.e. the entropy divided by
\eqn{\log(I)}, is also computed, under the assumption that all data categories are present in the dataset.
The relative entropy is useful for comparison across datasets with differen \eqn{I}.
The function is able to work with lattice data with missing data, as long as they are specified as NAs:
missing data are ignored in the computations.
}
\examples{
#NON SPATIAL DATA
shannon(sample(1:5, 50, replace=TRUE))

#POINT DATA
#requires marks with a finite number of categories
data.pp=runifpoint(100, win=square(10))
marks(data.pp)=sample(c("a","b","c"), 100, replace=TRUE)
shannon(marks(data.pp))

#LATTICE DATA
data.lat=matrix(sample(c("a","b","c"), 100, replace=TRUE), nrow=10)
shannon(data.lat)

}
