% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sbi}
\alias{sbi}
\title{Spatial Balance Index}
\usage{
sbi(dis, pi, s)
}
\arguments{
\item{dis}{A distance matrix NxN that specifies how far all the pairs
of units in the population are.}

\item{pi}{A vector of first order inclusion probabilities of the units
of the population.}

\item{s}{A vector of labels of the sample.}
}
\value{
Returns the Spatial Balance Index.
}
\description{
Computes the Spatial Balance Index (SBI), which is a measure of
spatial balance of a sample. The lower it is, the better the spread.
}
\details{
The SBI is based on Voronoi polygons. Given a sample s, each unit \eqn{i}
in the sample has its own Voronoi polygon, which is composed by all
population units closer to \eqn{i} than to any other sample unit \eqn{j}.
Then, per each Voronoi polygon, define \eqn{v_{i}} as the sum of the
inclusion probabilities of all units in the \eqn{i}-th Voronoi polygon.
Finally, the variance of \eqn{v_{i}} is the SBI.
}
\examples{
\dontshow{
d <- matrix(runif(200), 100, 2)
dis <- as.matrix(dist(d))
pi <- rep(10 / 100, 100)
s <- sample(1:100,10)
sbi(dis = dis, pi = pi, s = s)
}
\donttest{
dis <- as.matrix(dist(cbind(simul1$x, simul1$y))) # distance matrix
con <- rep(0, nrow(dis)) # vector of constraints
stand_dist <- stprod(mat = dis, con = con) # standardized matrix
pi <- rep(100 / nrow(dis), nrow(dis)) # vector of probabilities inclusion
s <- pwd(dis = stand_dist$mat, n = 100)$s # sample
sbi(dis = dis, pi = pi, s = s)
}
}
\references{
Stevens DL, Olsen AR (2004). Spatially Balanced Sampling of Natural Resources.
\emph{Journal of the American Statistical Association}, \strong{99}(465), 262-278.
\url{https://doi.org/10.1198/016214504000000250}
}
