% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrDiff.R
\name{CorrDiff}
\alias{CorrDiff}
\title{Calculate correlation difference between a forecast and a reference forecast, and assess uncertainty}
\usage{
CorrDiff(fcst, fcst.ref, obs, N.eff = NA, conf.level = 0.95,
  handle.na = "na.fail")
}
\arguments{
\item{fcst}{vector of forecasts}

\item{fcst.ref}{vector of reference forecasts}

\item{obs}{vector of observations}

\item{N.eff}{user-defined effective sample size to be used in hypothesis test and for confidence bounds; if NA, the length of `obs` is used after removing missing values; default: NA}

\item{conf.level}{confidence level for the confidence interval; default = 0.95}

\item{handle.na}{how should missing values in forecasts and observations be handled; possible values are 'na.fail' and 'only.complete.triplets'; default: 'na.fail'}
}
\value{
vector with correlation difference, one-sided p-value, and central confidence interval at the user-defined confidence level
}
\description{
Calculate correlation difference between a forecast and a reference forecast, and assess uncertainty
}
\examples{
data(eurotempforecast)
CorrDiff(rowMeans(ens), ens[, 1], obs)
}
\references{
Steiger (1980): Tests for comparing elements of a correlation matrix. Psychological Bulletin. http://dx.doi.org/10.1037/0033-2909.87.2.245 
Zou (2007): Toward using confidence intervals to compare correlations. Psychological Methods. http://dx.doi.org/10.1037/1082-989X.12.4.399
}
\seealso{
Corr
}
