% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitAkdParameters.R
\name{FitAkdParameters}
\alias{FitAkdParameters}
\title{Fit the 5 parameters used for affine kernel dressing by minimum CRPS estimation.}
\usage{
FitAkdParameters(ens, obs)
}
\arguments{
\item{ens}{a N*R matrix. An archive of R-member ensemble forecasts for N time instances.}

\item{obs}{a vector of length N. The verifying observations corresponding to the N ensemble forecasts.}
}
\value{
The function returns a list of 5 parameters for affine kernel dressing.
}
\description{
Fit the 5 parameters used for affine kernel dressing by minimum CRPS estimation.
}
\details{
Affine Kernel Dressing transforms the discrete K-member forecast ensemble at time instance n, `ens[n, ]`, to a continuous distribution function for the target `y` by the equation:

      p(y|ens) = 1 / K * sum {dnorm(y, z.i, s)} \cr
where   s = (4/3/K)^0.4 * (s1 + s2 * a^2 * var(ens)) \cr
and   z.i = r1 + r2 * mean(ens) + a * ens

The parameters r1, r2, a, s1, s2 are fitted by minimizing the continuously ranked probability score (CRPS). The optimization is carried out using the R function `optim(...)`.

Since the evaluation of the CRPS is numerically expensive, the optimization can take a long time. Speed can be increased by optimizing the parameters only for a part of the forecast instances.
}
\examples{
data(eurotempforecast)
FitAkdParameters(ens, obs)
}
\references{
Broecker J. and Smith L. (2008). From ensemble forecasts to predictive distribution functions. Tellus (2008), 60A, 663--678. \doi{10.1111/j.1600-0870.2008.00333.x}.
}
\seealso{
DressEnsemble, DressCrps, DressIgn, PlotDressedEns, GetDensity
}
