% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m6_stan.R
\name{m6_stan}
\alias{m6_stan}
\title{Bayesian M6 model with Stan}
\usage{
m6_stan(
  death,
  exposure,
  forecast,
  age,
  validation = 0,
  family = c("poisson", "nb"),
  ...
)
}
\arguments{
\item{death}{Matrix of deaths.}

\item{exposure}{Matrix of exposures.}

\item{forecast}{Number of years to forecast.}

\item{age}{Vector of ages.}

\item{validation}{Number of years for validation.}

\item{family}{specifies the random component of the mortality model. \code{"Poisson"} assumes a
Poisson model with log link and \code{"nb"} assumes a negative-binomial model
with log link and overdispersion parameter \eqn{\phi}.}

\item{...}{Arguments passed to \code{rstan::sampling} (e.g. iter, chains).}
}
\value{
An object of class \code{stanfit} returned by \code{rstan::sampling}.
}
\description{
Fit and Forecast Bayesian M6 model (CBD with cohort effect) introduced in Cairns et al (2009).
The model can be fitted with a Poisson or Negative-Binomial distribution. The function outputs posteriors distributions for each parameter,
predicted death rates and log-likelihoods.
}
\details{
The created model is either a log-Poisson or a log-Negative-Binomial version of
the M6 model:
\deqn{D_{x,t} \sim \mathcal{P}(\mu_{x,t} e_{x,t})}
or
\deqn{D_{x,t}\sim NB\left(\mu_{x,t} e_{x,t},\phi\right)}
with
\deqn{\log \mu_{xt} = \kappa_t^{(1)} + (x-\bar{x})\kappa_t^{(2)}+\gamma_{t-x},}
where \eqn{\bar{x}} is the average age in the data.

To ensure the identifiability of th model, we impose
\deqn{\gamma_1=0,\gamma_C=0,}
where \eqn{C} represents the most recent cohort in the data.

For the period terms, we consider a multivariate random walk with drift:
\deqn{\boldsymbol{\kappa}_{t}=\boldsymbol{c}+ \boldsymbol{\kappa}_{t-1}+\boldsymbol{\epsilon}_{t}^{\kappa},\quad \boldsymbol{\kappa}_{t}=\left(\begin{array}{c}\kappa_{t}^{(1)} \\\kappa_{t}^{(2)}\end{array}\right), \quad \boldsymbol{\epsilon}_{t}^{\kappa} \sim N\left(\mathbf{0}, \Sigma\right),}
with normal priors: \eqn{\boldsymbol{c} \sim N(0,10)}.

The variance-covariance matrix of the error term is defined by
\deqn{\boldsymbol{\Sigma}=\left(\begin{array}{cc}\sigma_1^{2} & \rho_{\Sigma} \sigma_1 \sigma_2 \\\rho_{\Sigma} \sigma_1 \sigma_{Y} & \sigma_2^{2}\end{array}\right)}
where the variance coefficients have independent exponential priors: \eqn{\sigma_1, \sigma_2 \sim Exp(0.1)}
and the correlation parameter has a uniform prior: \eqn{\rho_{\Sigma} \sim U\left[-1,1\right]}.
As for the other models, the overdispersion parameter has a prior distribution given by
\deqn{\frac{1}{\phi} \sim Half-N(0,1).}

For the cohort term, we consider a second order autoregressive process (AR(2)):
\deqn{\gamma_{c}=\psi_1 \gamma_{c-1}+\psi_2 \gamma_{c-2}+\epsilon^{\gamma}_{t},\quad \epsilon^{\gamma}_{t}\sim N(0,\sigma_{\gamma}).}

To close the model specification, we impose some vague priors assumptions on the hyperparameters:
\deqn{\psi_1,\psi_2 \sim N(0,10),\quad \sigma_{\gamma}\sim Exp(0.1).}
}
\examples{


#10-year forecasts for French data for ages 50-90 and years 1970-2017 with a log-Poisson model
ages.fit<-70:90
years.fit<-1990:2010
deathFR<-FRMaleData$Dxt[formatC(ages.fit),formatC(years.fit)]
exposureFR<-FRMaleData$Ext[formatC(ages.fit),formatC(years.fit)]
iterations<-50 # Toy example, consider at least 2000 iterations
fitM6=m6_stan(death = deathFR,exposure=exposureFR, age=ages.fit,forecast = 5,
family = "poisson",iter=iterations,chains=1)



}
\references{
Cairns, A. J. G., Blake, D., Dowd, K., Coughlan, G. D., Epstein, D.,
Ong, A., & Balevich, I. (2009). A quantitative comparison of stochastic
mortality models using data from England and Wales and the United States.
North American Actuarial Journal, 13(1), 1-35.
}
