% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ple_train.R
\name{predict.ple_train}
\alias{predict.ple_train}
\title{Patient-level Estimates Model: Prediction}
\usage{
\method{predict}{ple_train}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Trained ple model.}

\item{newdata}{Data-set to make predictions at (Default=NULL, predictions correspond
to training data).}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Data-frame with predictions (depends on trained ple model).
}
\description{
Prediction function for the trained patient-level estimate (ple) model.
}
\examples{
\donttest{
library(StratifiedMedicine)
## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A


# Fit through ple_train wrapper #
mod2 = ple_train(Y=Y, A=A, X=X, Xtest=X, ple="ple_ranger" )
summary(mod2$mu_train)

res2 = predict(mod2) # newdata=NULL, training data #
res3 = predict(mod2, newdata=X) # test data #
summary(res2)
summary(res3)
}

}
\seealso{
\code{\link{PRISM}}
}
