% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submod_glmtree.R
\name{submod_glmtree}
\alias{submod_glmtree}
\title{Subgroup Identification: Model-based partitioning (glmtree)}
\usage{
submod_glmtree(Y, A, X, Xtest, mu_train, glm.fam = binomial,
  link = "identity", alpha = 0.05, minsize = floor(dim(X)[1] * 0.1),
  maxdepth = 4, parm = NULL, ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{Xtest}{Test set}

\item{mu_train}{Patient-level estimates (See PLE_models)}

\item{glm.fam}{Family for GLM; default=binomial}

\item{link}{Link function for GLM; default="identity"}

\item{alpha}{Significance level for variable selection (default=0.05)}

\item{minsize}{Minimum number of observations in a tree node.
Default = floor( dim(train)[1]*0.05  )}

\item{maxdepth}{Maximum depth of any node in the tree (default=4)}

\item{parm}{Model parameters included in parameter instability tests 
(default=NULL, all parameters)}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Trained lmtree model.
 \itemize{
  \item mod - lmtree model object
}
}
\description{
Uses the glmtree (model-based partitioning, glms) algorithm to identify subgroups
(Zeileis, Hothorn, Hornik 2008). Usable for continuous and binary outcomes.
}
\examples{

\donttest{
library(StratifiedMedicine)

## Binomial ##
dat_bin = generate_subgrp_data(family="binomial")
Y = dat_bin$Y
X = dat_bin$X
A = dat_bin$A


res_glmtree1 = submod_glmtree(Y, A, X, Xtest=X)
res_glmtree2 = submod_glmtree(Y, A, X, Xtest=X, link="logit")
plot(res_glmtree1$mod)
plot(res_glmtree2$mod)
}


}
