% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supmz.R
\name{supmz}
\alias{supmz}
\alias{supmz.default}
\title{Detecting Structural Change with Heteroskedasticity}
\usage{
supmz(formula, data)

\method{supmz}{default}(formula, data)
}
\arguments{
\item{formula}{Formula for the linear model to be used. It may contain any number of independent variables.}

\item{data}{Data frame containing dependent and independent variables.}
}
\value{
MZ values as per given by Mumtaz et.al (2017)

SupMz.Value i.e. the supremum value from MZ values.

Break.Point.Location i.e. the data point number where the structural break occured.
}
\description{
Calculates the sup MZ value to detect the unknown structural break points under Heteroskedasticity
}
\examples{

data(Japan)
fm1 <- supmz(formula = C~Y, data = Japan)
fm1

data(Belgium)
fm2 <- supmz(formula = C~Y, data = Belgium)
fm2

data(Srilanka)
fm3 <- supmz(formula = C~Y, data = Srilanka)
fm3

}
\references{
Mumtaz Ahmed, Gulfam Haider & Asad Zaman (2017).
Detecting structural change with heteroskedasticity.
\emph{Communications in Statistics - Theory and Methods}.
\strong{46}(21):10446-10455,
DOI: 10.1080/03610926.2016.1235200
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Sami Ullah      (\email{samiullahuos@gmail.com})
         \item Gulfam Haider   (\email{haider.gulfam786@gmail.com})
         }
}
