% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmri_ROI_phase1.R
\name{fmri_ROI_phase1}
\alias{fmri_ROI_phase1}
\title{p-values on region of interest(ROI) of the brain}
\usage{
fmri_ROI_phase1(
  fmridata,
  label_mask = NULL,
  label_dict = NULL,
  stimulus_idx = NULL,
  rest_idx = NULL,
  p_threshold = 0.05
)
}
\arguments{
\item{fmridata}{a 4d array which contains the spatial and temporal record of fmri data}

\item{label_mask}{a 3D nifti or 3D array of data to indicates the corresponding indices of the ROIs}

\item{label_dict}{a dataframe which contains the name of ROIs and their corresponding index}

\item{stimulus_idx}{a vector that specifies when motion happens}

\item{rest_idx}{a vector that specifies when study participant does not move}

\item{p_threshold}{NULL or a numeric value that can be selected randomly below 0.05 to drop all p-values above the threshold.}
}
\value{
a list of two elements
\itemize{
  \item all_ROI - the test result for all ROIs
  \item sign_ROI - the test result for significant ROIs
}
}
\description{
This function takes a 4 dimensional real-valued fMRI data and calculates p-values for the ROIs individually to test whether the ROI is potentially activated.
It is the first phase of a ROI 3-phase analysis and usually followed by second phase analysis \code{fmri_ROI_phase2} .
}
\details{
The function \code{fmri_ROI_phase1} is used to calculate p-values of ROIs for a given real-valued fmridata. It first takes in the fmridata and corresponding mask. 
For a fixed region, the function will first compute Temporal Contrast-to-noise Ratio (tCNR) for each voxel in that region, which is the mean of 80 paired differences in intensity for "on" and "off" states divided by its standard deviation. Second, it will conduct t-test on all tCNRs of a fixed region to see there are significant changes for the ROI during the on and off period. Finally, it will use bonferroni correction to control significant level and select the ROIs with p-values under the significant level to enter next phase analysis.
}
\examples{
fmri_generate = fmri_simulate_func(dim_data = c(64, 64, 40), mask = mask)
# p-values for phase 1
\donttest{
result = fmri_ROI_phase1(fmri_generate$fmri_data, mask_label,
                          mask_dict, stimulus_idx = fmri_generate$on_time)
}
}
\author{
SOCR team <\url{http://socr.umich.edu/people/}>
}
