% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaultSC.R
\name{setParams}
\alias{setParams}
\title{Merge the parameters from a partial list and the default list}
\usage{
setParams(opts, defaultOpt, keepNotMatching = FALSE)
}
\arguments{
\item{opts}{a partial list of parameters}

\item{defaultOpt}{a list with default values for every element}

\item{keepNotMatching}{[FALSE] if TRUE, copy the elements appearing in \code{opts}, but not in 
\code{defaultOpt} to the return value. If FALSE, do not copy them, but issue a warning.}
}
\value{
a list combined from \code{opts} and \code{defaultOpt} where every available element 
   in \code{opts} overrides the default. For the rest of the elements the value from \code{defaultOpt}
   is taken. \cr
   A warning is issued for every element appearing in \code{opts} but not in \code{defaultOpt} 
   (only if \code{keepNotMatching==FALSE}).
}
\description{
Merge the parameters from a partial list and the default list
}
\seealso{
\code{\link{defaultSC}}, \code{\link{defaultOpts}}
}
\author{
Wolfgang Konen (\email{wolfgang.konen@th-koeln.de}), Samineh Bagheri
}
