% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaflowCalc.R
\name{Wat.transp}
\alias{Wat.transp}
\title{Calculate daily transpiration}
\usage{
Wat.transp(Sapflow, days, ID)
}
\arguments{
\item{Sapflow}{Vector with sap flow.}

\item{days}{Vector containg the days for which to calculate transpiration}

\item{ID}{Character vector containing identification for each sub-group}
}
\value{
Return a data frame with transpiration for each day and sub-group inputed
}
\description{
Calculate daily transpiration for each sub-group inputed
}
\details{
!!Beware of the units!! The Granier formula usually convert tension into sap flow density (in kg.dm-2.h-1). So, you should first convert sap flow density into sap flow (in kg.h-1). Moreover, if you take measurment every 30 minutes sap flow should be corrected by dividing the value by 2.
}
\examples{
ID = c(rep("A", times=5), rep("B", times=5), rep("A", times=5), rep("B", times=5))
Sapflow = c(rep(2.5, times=5), rep(2.7, times=5), rep(3.2, times=5), rep(3.4, times=5))
days = c(rep(102, times=10), rep(103, times=10))
Wat.transp(Sapflow=Sapflow, days=days, ID=ID)
}

