% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.functions.R
\name{tboot}
\alias{tboot}
\title{Calculate bootstrapped IndVal z scores}
\usage{
tboot(bSeq, env, taxa, ivTot = ivTot, minSplt = minSplt, nPerm = nPerm,
  memory = memory, imax = imax)
}
\arguments{
\item{bSeq}{An index used to determine the sequence number of the
current bootstrap replicate.}

\item{env}{An environmental gradient.}

\item{taxa}{A site-by-taxon matrix of taxa counts at each
sampling location.}

\item{ivTot}{A logical indicating whether IndVal scores should be
calculated using total relative abundance or the mean relative
abundace originally proposed by Dufrene and Legendre (1997).
The default is to pass on the argument from the original TITAN
funtion call.}

\item{minSplt}{The minimum bin size for partitioning along the
environmental gradient.  The default is to pass on the argument
from the original TITAN funtion call.}

\item{nPerm}{The number of replicates used by the permutation
procedure (not to be confused with the number of bootstrap
replicates). The default is to pass on the argument from the
original TITAN funtion call.}

\item{memory}{A logical indicating whether scratch files should
be used to store temporary data in order to preserve RAM during
bootstrapping of large data sets.  The default is to pass on
the argument from the original TITAN funtion call.}

\item{imax}{A logical indicating whether taxon-specific change
points should be determined by IndVal maxima or z-score maxima
(as in Baker and King 2010). The default is to pass on the
argument from the original TITAN funtion call.}
}
\value{
A list of four elements: \itemize{ \item{bt.metrics }{A
  matrix with nrow equal to number of taxa where the first column
  is the bootstrapped IndVal or z score maximum, the second is
  the environmental value, the third is the indicator direction,
  and the fourth is the p value at that point.} \item{ivzs }{Z
  scores for all taxa across candidate change points in the
  replicate sample} \item{bsrti }{A sorted version of the
  bootstrapped environmental gradient} \item{rspdr }{Response
  direction (1 or 2) for all taxa across candidate change points
  in the replicate sample} }
}
\description{
This function implements resampling (with replacement) of the
observed environmental gradient and site-by-taxon matrix, and
then calls the function \code{b.getivz} to obtain
bootstrapped scores.
}
\details{
Four pieces of information are obtained from every taxon during
each bootstrap replicate. If the argument 'imax' is TRUE,
bootstrapped change points are identified based on IndVal maxima,
whereas if 'imax' is FALSE z-score maxima are used instead.  In
addition to the IndVal or z score maxima, the value of the
environmental gradient, the indicator direction, and the p value
are also retained for that point.

In addition to the above metric matrix for each taxon (1), the z
scores across all candidate chnage points are retained from each
replicate (2), as well as the response direction (maxgrp) (3) and
a sorted version of resampled environmental values (4).  These
four items are combined as a list object.
}
\author{
M. Baker and R. King
}
\references{
Baker, ME and RS King.  2010. A new method for
  detecting and interpreting biodiversity and ecological
  community thresholds. Methods in Ecology and Evolution 1(1):
  25:37.
}
\seealso{
\code{\link{b.getivz}}, \code{\link{ivzsums}}
}
\keyword{TITAN}
\keyword{bootstrap}

