% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local-collections.R
\name{map_collection_members}
\alias{map_collection_members}
\title{Map different collection members}
\usage{
map_collection_members(
  x,
  y,
  collection,
  xm,
  ym,
  suffix = c("_x", "_y"),
  fun = NA,
  ...
)
}
\arguments{
\item{x}{a data.frame}

\item{y}{a data.frame}

\item{collection}{the name of the collection.}

\item{xm}{collection member x: a data.frame with the fields
"field", "static", "value", "type" as returned by
the \code{\link[=read_collection_members]{read_collection_members()}} function.}

\item{ym}{collection member y: a data.frame with the fields
"field", "static", "value", "type" as returned by
the \code{\link[=read_collection_members]{read_collection_members()}} function.}

\item{suffix}{the suffix to append to field names from x and y tables.
Default: \code{c("_x", "_y")}}

\item{fun}{the function used to map x and y collection members.
By default (NA) it is automatically identified if recorded in the system.
The way to write this function is provided in the details section.}

\item{...}{additional parameters for the fun function.}
}
\value{
A tibble giving necessary information to map elements in x and y.
The columns corresponds to the field values in xm and ym followed by a
suffix (default: \code{c("_x", "_y")}). Only fields documented as non static
in xm and ym are kept.
}
\description{
Map different collection members
}
\details{
fun must have at least an x and a y parameters.
Each of them should be a data.frame with all the field values
given in xm and ym. Additional parameters
can be defined and will be forwarded using \code{...}.
fun should return a data frame with all the fields values
given in xm and ym followed by "_x" and "_y" suffix.
}
