% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-management.R
\name{parse_R_helpers}
\alias{parse_R_helpers}
\title{Parse source code to get R helpers}
\usage{
parse_R_helpers(code, ...)
}
\arguments{
\item{code}{the source code as a character vector}

\item{...}{other objects to add in the environment of the returned functions}
}
\value{
A list of functions from \code{code} plus an "help" function used to get
function documentation.
}
\description{
Parse source code to get R helpers
}
\details{
Functions in code must be documented
with \link[roxygen2:roxygen2-package]{roxygen2::roxygen2-package}
tags and only functions with the '@export' tag are returned.
}
\examples{
{

code <- "
   a <- 2
   #' Set the 'a' value to use in the add_a function
   #' 
   #' @param v a numeric value
   #' 
   #' @return Does not return anything
   #' 
   #' @export
   set_a <- function(v) a <<- v
   
   #' Add a 'a' value defined separately
   #' 
   #' @param x a numeric value
   #' 
   #' @return x + a
   #' 
   #' @export
   add_a <- function(x) x + a
   
   #' Add a 'a' value defined separately to a b value made available
   #' in environment
   #' 
   #' 
   #' @return b + a
   #' 
   #' @export
   add_a_to_b <- function() b + a
"
helpers <- parse_R_helpers(code, b=3)
helpers$help()
helpers$help("add_a")
helpers$add_a(3.5)
helpers$set_a(4)
helpers$add_a(3.5)
helpers$add_a_to_b()
helpers <- parse_R_helpers(code, b=6)
helpers$add_a_to_b()

}

}
