% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.parameters.R
\name{summary.parameters}
\alias{summary.parameters}
\title{Summary parameters}
\usage{
\method{summary}{parameters}(object, ci.level = 0.9, ...)
}
\arguments{
\item{object}{object of parameters.}

\item{ci.level}{numeric vector of length 1 giving the confidence level (default is 0.9).}

\item{...}{additional arguments submitted to \code{est_cov}.}
}
\value{
A \code{summary.parameters}-object, a list with dimensions \itemize{
 \item \code{param}
 \item \code{ci.level}
 \item \code{ci}
 \item \code{cov}
}
It is printed with \code{print.summary.parameters}.
}
\description{
Calculating and printing of summary statistics to a given parameters-object.
}
\examples{
x <- cbind(rgev(100, shape = .2), rgev(100, shape = .2))

p <- parameters(TLMoments(x[, 1]), "gev")
summary(p)
summary(p, select = c("scale", "shape"))

p <- parameters(TLMoments(x[, 1], rightrim = 1), "gev")
summary(p)

p <- parameters(TLMoments(x), "gev")
summary(p)
summary(p, select = "shape")

p <- as.parameters(loc = 10, scale = 5, shape = .3, distr = "gev")
summary(p)
summary(p, rightrim = 1, set.n = 250)

}
\seealso{
\code{\link{parameters}}, \code{\link{est_cov}}
}
