% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_ses_calc.R
\name{boot_ses_calc}
\alias{boot_ses_calc}
\alias{boot_ses_calc.default}
\alias{boot_ses_calc.formula}
\title{Bootstrap SES Calculation}
\usage{
boot_ses_calc(
  x,
  ...,
  paired = FALSE,
  ses = "rb",
  alpha = 0.05,
  boot_ci = c("basic", "stud", "perc"),
  R = 1999
)

\method{boot_ses_calc}{default}(
  x,
  y = NULL,
  paired = FALSE,
  ses = c("rb", "odds", "logodds", "cstat"),
  alpha = 0.05,
  boot_ci = c("basic", "stud", "perc"),
  R = 1999,
  ...
)

\method{boot_ses_calc}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{...}{further arguments to be passed to or from methods.}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{ses}{Standardized effect size. Default is "rb" for rank-biserial
correlation. Options also include "cstat" for concordance probability, or
"odds" for Wilcoxon-Mann-Whitney odds (otherwise known as Agresti's
generalized odds ratio).}

\item{alpha}{alpha level (default = 0.05)}

\item{boot_ci}{type of bootstrap confidence interval. Options include studentized (stud), empirical/basic (basic) and percentile (perc) confidence intervals.}

\item{R}{number of bootstrap replicates}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{formula}{a formula of the form lhs ~ rhs where lhs is a numeric variable giving the data values and rhs either 1 for a one-sample or paired test or a factor with two levels giving the corresponding groups. If lhs is of class "Pair" and rhs is 1, a paired test is done.}

\item{data}{an optional matrix or data frame (or similar: see model.frame) containing the variables in the formula formula. By default the variables are taken from environment(formula).}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. Defaults to getOption("na.action").}
}
\value{
A data frame containing the standardized effect size.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

Standardized effect size (SES), these are the effect sizes not considered SMDs.
}
\details{
For details on the calculations in this function see \code{vignette("robustTOST")}.
}
\examples{
\dontrun{
boot_ses_calc(formula = extra ~ group, data = sleep, paired = TRUE, ses = "r")
}
}
\seealso{
Other effect sizes: 
\code{\link{boot_smd_calc}()},
\code{\link{ses_calc}()},
\code{\link{smd_calc}()}
}
\concept{effect sizes}
