% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_TOST.R
\name{t_TOST}
\alias{t_TOST}
\alias{t_TOST.default}
\alias{t_TOST.formula}
\title{TOST with t-tests}
\usage{
t_TOST(
  x,
  ...,
  hypothesis = "EQU",
  paired = FALSE,
  var.equal = FALSE,
  eqb,
  low_eqbound,
  high_eqbound,
  eqbound_type = "raw",
  alpha = 0.05,
  bias_correction = TRUE,
  rm_correction = FALSE,
  glass = NULL,
  smd_ci = c("nct", "goulet", "t", "z")
)

\method{t_TOST}{default}(
  x,
  y = NULL,
  hypothesis = c("EQU", "MET"),
  paired = FALSE,
  var.equal = FALSE,
  eqb,
  low_eqbound,
  high_eqbound,
  eqbound_type = c("raw", "SMD"),
  alpha = 0.05,
  mu = 0,
  bias_correction = TRUE,
  rm_correction = FALSE,
  glass = NULL,
  smd_ci = c("nct", "goulet", "t", "z"),
  ...
)

\method{t_TOST}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{...}{further arguments to be passed to or from methods.}

\item{hypothesis}{'EQU' for equivalence (default), or 'MET' for minimal effects test, the alternative hypothesis.}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{var.equal}{a logical variable indicating whether to treat the two variances as being equal. If TRUE then the pooled variance is used to estimate the variance otherwise the Welch (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{eqb}{Equivalence bound. Can provide 1 value (negative value is taken as the lower bound) or 2 specific values that represent the upper and lower equivalence bounds.}

\item{low_eqbound}{lower equivalence bounds (deprecated).}

\item{high_eqbound}{upper equivalence bounds (deprecated).}

\item{eqbound_type}{Type of equivalence bound. Can be set to "SMD" for standardized mean difference (i.e., Cohen's d) or  "raw" for the mean difference. Default is "raw". Raw is strongly recommended as SMD bounds will produce biased results.}

\item{alpha}{alpha level (default = 0.05)}

\item{bias_correction}{Apply Hedges' correction for bias (default is TRUE).}

\item{rm_correction}{Repeated measures correction to make standardized mean difference Cohen's d(rm). This only applies to repeated/paired samples. Default is FALSE.}

\item{glass}{A option to calculate Glass's delta as an alternative to Cohen's d type SMD. Default is NULL to not calculate Glass's delta, "glass1" will use the first group's SD as the denominator whereas "glass2" will use the 2nd group's SD.}

\item{smd_ci}{Method for calculating SMD confidence intervals. Methods include Goulet, noncentral t (nct), central t (t), and normal method (z).}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{mu}{a number indicating the true value of the mean for the two tailed test (or difference in means if you are performing a two sample test).}

\item{formula}{a formula of the form lhs ~ rhs where lhs is a numeric variable giving the data values and rhs either 1 for a one-sample or paired test or a factor with two levels giving the corresponding groups. If lhs is of class "Pair" and rhs is 1, a paired test is done.}

\item{data}{an optional matrix or data frame (or similar: see model.frame) containing the variables in the formula formula. By default the variables are taken from environment(formula).}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. Defaults to getOption("na.action").}
}
\value{
An S3 object of class
\code{"TOSTt"} is returned containing the following slots:
\itemize{
\item "TOST": A table of class \code{"data.frame"} containing two-tailed t-test and both one-tailed results.
\item "eqb": A table of class \verb{"data.frame}" containing equivalence bound settings.
\item "effsize":  table of class \code{"data.frame"} containing effect size estimates.
\item "hypothesis": String stating the hypothesis being tested
\item "smd": List containing the results of the standardized mean difference calculations (e.g., Cohen's d).
\itemize{
\item Items include: d (estimate), dlow (lower CI bound), dhigh (upper CI bound), d_df (degrees of freedom for SMD), d_sigma (SE), d_lambda (non-centrality), J (bias correction), smd_label (type of SMD), d_denom (denominator calculation)
}
\item "alpha": Alpha level set for the analysis.
\item "method": Type of t-test.
\item "decision": List included text regarding the decisions for statistical inference.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A function for TOST with all types of t-tests.
}
\details{
For details on the calculations in this function see vignette("IntroTOSTt") & vignette("SMD_calcs").

For two-sample tests, the test is of \eqn{\bar x - \bar y} (mean of x minus mean of y).
For paired samples, the test is of the difference scores (z),
wherein \eqn{z =  x - y}, and the test is of \eqn{\bar z} (mean of the difference scores).
For one-sample tests, the test is of \eqn{\bar x } (mean of x).
}
\examples{
data(mtcars)
t_TOST(mpg ~ am,
data = mtcars,
eqb = 3)
}
\seealso{
Other TOST: 
\code{\link{boot_log_TOST}()},
\code{\link{boot_t_TOST}()},
\code{\link{simple_htest}()},
\code{\link{tsum_TOST}()},
\code{\link{wilcox_TOST}()}
}
\concept{TOST}
