% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DMMprocess.R
\name{DMMprocess}
\alias{DMMprocess}
\title{Dynamic material modeling from strain rate temperature table}
\usage{
DMMprocess(
  x,
  lgbase = 10,
  InteractMode = FALSE,
  ConsFunc = FALSE,
  legendcex = 0.65,
  legendloc = "bottomright"
)
}
\arguments{
\item{x}{A strain rate-temperature table, returned from \code{\link[TPMplt:epsExtract]{epsExtract}}.}

\item{lgbase}{A numeric value to specify the base of the logarithm calculations for processing map.
The default value uses 10.}

\item{InteractMode}{A boolean value to control figures' output and the printout of related constants
during calculations. Default value FALSE means all fitting plots will not be outputed. If these outputs
are necessary, set this parameter as TRUE then follow the prompt messages.}

\item{ConsFunc}{A boolean value to determine whether calculating for constructive equation. The
default value uses FALSE.}

\item{legendcex}{A numeric value to determine the legend scale. It is activated only when the parameter
InteractMode is TRUE. The default value is 0.65.}

\item{legendloc}{A character object to determine the location of legend. It is activated only when the
parameter InteractMode is TRUE. The defualt value is "bottomright".}
}
\value{
Serial material constants, constructive function, eta table and xi table through
dynamic material model developed by Gegel and Prasad.
}
\description{
Dynamic material modeling based on strain rate-temperature table returned from
the function \code{\link[TPMplt:epsExtract]{epsExtract}}. Material constants as well as power
dissipation efficiency factors and rheological stability coefficients in current conditions
will be returned.
}
\examples{
require(VBTree)
dl2vbt(chrvec2dl(colnames(TPMdata)))
epstable <- epsExtract(TPMdata, 0.7, 2, 3)

# Without calculation for constitutive equation
DMM <- DMMprocess(epstable)
message(DMM)

# Calculating for constitutive equation but
# Without plots printout.
DMM <- DMMprocess(epstable, ConsFunc=TRUE)
message(DMM)

# Calculating for constitutive equation and
# required fitting plots printout. (message and selection in prompt)
\dontrun{
DMMprocess(epstable, InteractMode=TRUE, ConsFunc=TRUE)
}

}
\seealso{
\code{\link[VBTree:VBTree-package]{VBTree}}, \code{\link[TPMplt:epsExtract]{epsExtract}}
}
\keyword{DMMprocess}
\keyword{DMMresult}
\keyword{epsExtract}
