% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap}
\alias{bootstrap}
\title{bootstrap}
\usage{
bootstrap(x, trt = NULL, trt_control = "Control", FUN = NULL,
  varname = NULL, varcol = NULL, arglist = NULL, n_samples = 1)
}
\arguments{
\item{x}{Source data to bootstrap.}

\item{trt}{Treatment variable. (optional)}

\item{trt_control}{Value for treatment control arm. Default value is 'Control'.}

\item{FUN}{Function to compute statistic for each bootstrap sample. (optional)}

\item{varname}{Name of variable in x on which to compute FUN. If x has only
one column varname is not needed. If x has more than one column then either
varname or varcol must be specified.}

\item{varcol}{Column index of x on which to compute FUN. If x has only one
column varcol is not needed. If x has more than one column then either varname
or varcol must be specified.}

\item{arglist}{List of additional arguments to pass to FUN.}

\item{n_samples}{Number of bootstrap samples to generate.}
}
\value{
If FUN is NULL returns a vector of objects of class
\linkS4class{Bootstrap}. If FUN is non-NULL returns a vector of objects
of class \linkS4class{BootstrapStatistic}
}
\description{
Generate a vector of bootstrap samples.
}
\details{
Each bootstrap sample will retain the in-bag and out-of-bag data.
Optionally, the user may specify a function to compute a statistic for each
in-bag and out-of-bag sample. This function may be a built-in R function
(e.g. mean, median, etc.) or a user-defined function (see Examples). If no
statistic function is provided bootstrap returns a vector of objects of class
\linkS4class{Bootstrap}. If a statistic function is provided bootstrap
returns a vector of objects of class \linkS4class{BootstrapStatistic},
which in addition to the in-bag and out-of-bag samples contains the name of
the statistic, variable on which the statistic is computed, and the numerical
result of the statistic for each in-bag and out-of-bag sample.
}
\examples{
## Generate example data frame containing response and treatment
N <- 20
x <- data.frame( runif( N ) )
names( x ) <- "response"
x$treatment <- factor( sample( c("Control","Experimental"), size = N,
                       prob = c(0.8,0.2), replace = TRUE ) )

## Generate two bootstrap samples without regard to treatment
ex1 <- bootstrap( x, n_samples = 2 )

## Generate two bootstrap samples stratified by treatment
ex2 <- bootstrap( x, trt = x$treatment, trt_control = "Control", n_samples = 2 )

## For each bootstrap sample compute a statistic on the in-bag and out-of-bag data
ex3 <- bootstrap( x, FUN = mean, varname = "response", n_samples = 2 )

## Specify a user-defined function that takes a numeric vector input and
## returns a numeric result
sort_and_rank <- function( z, rank ){
  z <- sort( z )
  return( z[rank] )
}

ex4 <- bootstrap( x, FUN = sort_and_rank, arglist = list( rank = 1 ),
                  varname = "response", n_samples = 2 )
}
\seealso{
\linkS4class{Bootstrap}, \linkS4class{BootstrapStatistic}
}
