% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_functions.R
\name{ccf_plot}
\alias{ccf_plot}
\title{Time Series Cross Correlation Lags Visualization}
\usage{
ccf_plot(x, y, lags = 0:12, margin = 0.02, n_plots = 3, Xshare = TRUE,
  Yshare = TRUE, title = NULL)
}
\arguments{
\item{x}{A univariate time series object of a class "ts"}

\item{y}{A univariate time series object of a class "ts"}

\item{lags}{An integer, set the lags range, 
by default will plot the two series along with the first 12 lags}

\item{margin}{Plotly parameter, either a single value or four values (all between 0 and 1).
If four values provided, the first will be used as the left margin, 
the second will be used as the right margin, 
the third will be used as the top margin, 
and the fourth will be used as the bottom margin. 
If a single value provided, it will be used as all four margins.}

\item{n_plots}{An integer, define the number of plots per row}

\item{Xshare}{Plotly parameter, should the x-axis be shared amongst the subplots?}

\item{Yshare}{Plotly parameter, should the y-axis be shared amongst the subplots?}

\item{title}{A character, optional, set the plot title}
}
\value{
Plot
}
\description{
Visualize the series y against the series x lags (according to the setting of the lags argument) 
and return the corresponding cross-correlation value for each lag
}
\examples{

data("USUnRate")
data("USVSales")

ccf_plot(x = USVSales, y = USUnRate)

#Plotting the first 6 lead and lags of the USVSales with the USUnRate
ccf_plot(x = USVSales, y = USUnRate, lags = -6:6)

# Setting the plot margin and number of plots in each raw
ccf_plot(x = USVSales, y = USUnRate, lags = c(0, 6, 12, 24), 
margin = 0.01,  n_plots = 2)
}
