% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Taba.R
\name{taba}
\alias{taba}
\title{Robust Correlation}
\usage{
taba(x, y, method = c("taba", "tabarank","tabwil", "tabwilrank"), omega)
}
\arguments{
\item{x}{A numeric vector of length greater than 2 must be same length as y}

\item{y}{A numeric vector of length greater than 2 must be same length as x}

\item{method}{A character string of \code{"taba"}, \code{"tabarank"}, \code{"tabwil"}, or
\code{"tabwilrank"} determining if one wants to calculate Taba linear, Taba rank
(monotonic), TabWil, or TabWil rank correlation, respectively. If no method is specified,
the function will output Taba Linear correlation.}

\item{omega}{Numeric allowing the user to alter the tuning constant. If one is not specified,
the function will default to 0.45 for Taba and Taba rank, and 0.1 for TabWil and TabWil rank.
Range is between 0 and 1.}
}
\value{
This function returns a the robust linear or monotonic association
  between two numeric vectors as a numeric.
}
\description{
Returns the Taba robust linear, Taba rank (monotonic), TabWil, or
   TabWil rank correlation coefficient between two numeric vectors.
}
\details{
This function can be used to compare two non-empty numeric vectors of
   length greater than two, or two columns of a data frame or matrix composed
   of more than two numeric elements. Missing values in either x or y are
   deleted row-wise. The default method is Taba Linear correlation, with the
   tuning constant \code{omega}.
}
\examples{
x = rnorm(100)
y = rnorm(100)
taba(x, y)
taba(x, y, method = "tabarank", omega = 0.4)
taba(x, y, method = "tabwil", omega = 0.22)
}
\references{
The paper is under review for possible publication.
}
\seealso{
\code{\link{taba.test}} for testing Taba linear or Taba rank (monotonic) correlations
  \cr\code{\link{taba.partial}} for partial and semipartial correlations
  \cr\code{\link{taba.gpartial}} for generalized partial correlations
  \cr\code{\link{taba.matrix}} for calculating correlation, p-value, and distance matricies
}
