% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Int_E_VOL_AB_HmDm_HT_dHt.f.R
\name{Int_E_VOL_AB_HmDm_HT_dHt.f}
\alias{Int_E_VOL_AB_HmDm_HT_dHt.f}
\title{Int_E_VOL_AB_HmDm_HT_dHt.f}
\usage{
Int_E_VOL_AB_HmDm_HT_dHt.f(
  Hm,
  Dm,
  A = NULL,
  B = NULL,
  iDH = "D",
  mw_HtT,
  sd_HtT,
  par.lme,
  Rfn = list(fn = "sig2"),
  IA = FALSE,
  nGL = 51,
  ...
)
}
\arguments{
\item{Hm}{Numeric vector of stem heights (m) along which diameter measurements 
were taken for calibration. Can be of length 1. Must be of same length as \code{Dm}}

\item{Dm}{Numeric vector of diameter measurements (cm) taken for calibration.
Can be of length 1. Must be of same length as \code{Hm}}

\item{A}{Numeric scalar defining the lower threshold of a stem section for volume
estimation. Depends on \code{iDH}. If \code{iDH} = "D", a diameter
(cm), if \code{iDH} = "H", a height (m). If NULL, section starts at lowest point.}

\item{B}{Numeric scalar defining the upper threshold of a stem section for volume
estimation. Depends on \code{iDH}. If \code{iDH} = "D", a diameter
(cm), if \code{iDH} = "H", a height (m). If NULL, section ends at tip.}

\item{iDH}{Character scalar. Either "D" or "H". Type of threshold for
section volume estimation. See \code{A} or \code{B}.}

\item{mw_HtT}{Scalar. Tree height (m)}

\item{sd_HtT}{Scalar. Standard deviation of stem height. Can be 0 if height was 
measured without error}

\item{par.lme}{List of taper model parameters obtained by \code{\link{TapeR_FIT_LME.f}}}

\item{Rfn}{list with function name to provide estimated or assumed residual 
variances for the given measurements, optionally parameters for such functions}

\item{IA}{Logic scalar. If TRUE, variance calculation of height
estimate based on 2-point distribution. If FALSE, variance calculation of height
estimate based on Normal approximation.}

\item{nGL}{Numeric scalar. Number of support points for numerical integration.}

\item{...}{not currently used}
}
\value{
list with expected volume, variance of volume and squared expected value
incorporating the uncertainty of height measurement
}
\description{
Internal function not usually called by users
}
\details{
integrating the taper curve considering uncertainty of height 
measurement
}
\author{
Edgar Kublin
}
