% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS_extended.R
\name{charKRTS}
\alias{charKRTS}
\title{Characteristic function of the Kim-Rachev tempered stable distribution}
\usage{
charKRTS(
  t,
  alpha = NULL,
  kp = NULL,
  km = NULL,
  rp = NULL,
  rm = NULL,
  pp = NULL,
  pm = NULL,
  mu = NULL,
  theta = NULL
)
}
\arguments{
\item{t}{A vector of real numbers where the CF is evaluated.}

\item{alpha}{Stability parameter. A real number between 0 and 1.}

\item{kp, km, rp, rm}{Parameter of KR-distribution. A real number \code{>0}.}

\item{pp, pm}{Parameter of KR-distribution. A real number \code{>-alpha}.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}
}
\value{
The CF of the the Kim-Rachev tempered stable distribution.
}
\description{
Theoretical characteristic function (CF) of the Kim-Rachev tempered
stable distribution.
}
\details{
The CF of the RDTS distribution is given by (Rachev et
al. (2011))

\deqn{\varphi_{KRTS}(t;\theta):=
E_{\theta}\left[\mathrm{e}^{\mathrm{i}tX}\right]=
\exp\left(\mathrm{i}t\mu-\mathrm{i}t\Gamma(1-\alpha)
\left(\frac{k_+r_+}{p_++1}-\frac{k_-r_-}{p_-+1}\right) \right.\\}
\deqn{\left. +k_+H(\mathrm{i}t;\alpha,r_+,p_+)+k_
-H(-\mathrm{i}t;\alpha,r_-,p_-)\right),}
where
\deqn{\left. H\left(x;\alpha,r,p\right)=
\frac{\Gamma(-\alpha)}{p}\left(F\left(p,-\alpha;1+p;rx\right)-1\right)\right.
}
\code{F} denotes the hypergeometric Function.
}
\examples{
x <- seq(-5,5,0.25)
y <- charKRTS(x,0.5,1,1,1,1,1,1,0)

}
\references{
Rachev, Svetlozar T. & Kim, Young Shin & Bianchi, Michele L. & Fabozzi,
Frank J. (2011) 'Financial models with Lévy processes and volatility
clustering' \doi{10.1002/9781118268070}
}
