% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_TemporalGSSA.R
\name{check_TemporalGSSA}
\alias{check_TemporalGSSA}
\title{check_TemporalGSSA()}
\usage{
check_TemporalGSSA(data, type)
}
\arguments{
\item{data}{Formatted data from the output of a GillespieSSA run
This is a mandatory argument.}

\item{type}{A mandatory integer argument that indicates the statistic to
be used to compute the representative timestep for a set of observations.
Here: "1" is the MEAN, "2" is the MEDIAN, "3" is a random choice, "4" ALL}
}
\value{
flag A numeric indicator of the suitability of the user-defined input
data for further computations.
}
\description{
This function of the package 'TemporalGSSA' checks whether the user-defined
data is suitable for further processing.
}
\details{
The number of observations must be at least 30 (consective runs of 'GillespieSSA') 
to generate data that is statistically significant. The user must also enter a choice that
specifies the statistical modality utilized to compute a representative timestep
 (1, mean; 2, median; 3, random; 4, all). Both arguments are mandatory.
}
