% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{TernaryApp}
\alias{TernaryApp}
\title{Graphical user interface for creating ternary plots}
\usage{
TernaryApp()
}
\description{
\code{TernaryApp()} launches a 'Shiny' application for the construction of
ternary plots.  The 'app' allows data to be loaded and plotted, and provides
code to reproduce the plot in R should more sophisticated plotting functions
be desired.
}
\details{
\subsection{Load data}{

The 'Load data' input tab allows for the upload of datasets.
Data can be read from csv files, \code{.txt} files created with \code{write.table()},
or (if the 'readxl' package is installed) Excel spreadsheets.

Data should be provided as three columns, corresponding to the three axes
of the ternary plot.  Colours or point styles may be specified in columns
four to six to allow different categories of point to be plotted distinctly.
Example datasets are installed at
C:/Research/R/Ternary/inst/TernaryApp.

Axes are automatically labelled using column names, if present; these can be
edited manually on this tab.
}

\subsection{Plot display}{

Allows the orientation, colour and configuration of the plot and its axes
to be adjusted,
}

\subsection{Grids}{

Adjust the number, spacing and styling of major and minor grid lines.
}

\subsection{Labels}{

Configure the colour, position and size of tip and axis labels.
}

\subsection{Points}{

Choose whether to plot points, lines, connected points, or text.
Set the style of points and lines.
}
}
\section{Exporting plots}{
A plot can be saved to PDF or as a PNG bitmap at a specified size.
Alternatively, R script that will generate the displayed plot can be viewed
(using the 'R code' output tab) or downloaded to file.
}

\references{
If you use figures produced with this package in a publication, please cite

Smith, Martin R. (2017). \emph{Ternary: An R Package for Creating Ternary Plots.}
Zenodo, doi: \href{https://dx.doi.org/10.5281/zenodo.1068996}{10.5281/zenodo.1068996}.
}
\seealso{
Full detail of plotting with 'Ternary', including features not (yet)
implemented in the application, is provided in the accompanying
\href{https://ms609.github.io/Ternary/articles/Ternary.html}{vignette}.
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
