% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Holdridge.R, R/TernaryPlot.R
\name{AddToHoldridge}
\alias{AddToHoldridge}
\alias{HoldridgeArrows}
\alias{HoldridgeLines}
\alias{HoldridgePoints}
\alias{HoldridgePolygon}
\alias{HoldridgeText}
\alias{AddToTernary}
\alias{TernarySegments}
\alias{TernaryArrows}
\alias{TernaryLines}
\alias{TernaryPoints}
\alias{TernaryPolygon}
\alias{TernaryText}
\alias{JoinTheDots}
\title{Add elements to ternary or Holdridge plot}
\usage{
AddToHoldridge(PlottingFunction, pet, prec, ...)

HoldridgeArrows(fromCoordinates, toCoordinates = fromCoordinates, ...)

HoldridgeLines(pet, prec, ...)

HoldridgePoints(pet, prec, ...)

HoldridgePolygon(pet, prec, ...)

HoldridgeText(pet, prec, ...)

AddToTernary(PlottingFunction, coordinates, ...)

TernarySegments(fromCoordinates, toCoordinates = fromCoordinates, ...)

TernaryArrows(fromCoordinates, toCoordinates = fromCoordinates, ...)

TernaryLines(coordinates, ...)

TernaryPoints(coordinates, ...)

TernaryPolygon(coordinates, ...)

TernaryText(coordinates, ...)

JoinTheDots(coordinates, ...)
}
\arguments{
\item{PlottingFunction}{Function to add data to a plot; perhaps one of
\code{\link[graphics]{points}},
\code{\link[graphics]{lines}} or
\code{\link[graphics]{text}}.}

\item{pet, prec}{Numeric vectors giving \emph{p}otential \emph{e}vapo\emph{t}ranspiration
ratio and annual \emph{prec}ipitation (in mm).}

\item{\dots}{Additional parameters to pass to \code{PlottingFunction()}.
If using \code{TernaryText()}, this will likely include the parameter \code{labels},
to specify the text to plot. Other useful
\link[graphics:par]{graphical parameters} include \code{srt} to rotate text.}

\item{fromCoordinates, toCoordinates}{For \code{TernaryArrows()}, coordinates at
which arrows should begin and end; \emph{cf.} \code{x0}, \code{y0}, \code{x1} and \code{y1} in
\link[graphics]{arrows}.  Recycled as necessary.}

\item{coordinates}{A list, matrix, data.frame or vector in which each
element (or row) specifies
the three coordinates of a point in ternary space.}
}
\description{
Plot shapes onto a ternary diagram created with \code{\link[=TernaryPlot]{TernaryPlot()}},
or a Holdridge plot created with \code{\link[=HoldridgePlot]{HoldridgePlot()}}.
}
\section{Functions}{
\itemize{
\item \code{HoldridgeArrows()}: Add  \link[graphics]{arrows} to Holdridge plot

\item \code{HoldridgeLines()}: Add \link[graphics]{lines} to Holdridge plot

\item \code{HoldridgePoints()}: Add \link[graphics]{points} to Holdridge plot

\item \code{HoldridgePolygon()}: Add \link[graphics:polygon]{polygons} to Holdridge
plot

\item \code{HoldridgeText()}: Add \link[graphics]{text} to Holdridge plot

\item \code{TernarySegments()}: Add \link[graphics]{segments}

\item \code{TernaryArrows()}: Add  \link[graphics]{arrows}

\item \code{TernaryLines()}: Add \link[graphics]{lines}

\item \code{TernaryPoints()}: Add \link[graphics]{points}

\item \code{TernaryPolygon()}: Add \link[graphics:polygon]{polygons}

\item \code{TernaryText()}: Add \link[graphics]{text}

\item \code{JoinTheDots()}: Add points, joined by lines

}}
\examples{
# Data to plot
coords <- list(
  A = c(1, 0, 2),
  B = c(1, 1, 1),
  C = c(1.5, 1.5, 0),
  D = c(0.5, 1.5, 1)
)

# Set up plot
oPar <- par(mar = rep(0, 4), xpd = NA) # reduce margins and write in them
TernaryPlot()

# Add elements to ternary diagram
AddToTernary(lines, coords, col = "darkgreen", lty = "dotted", lwd = 3)
TernaryLines(coords, col = "darkgreen")
TernaryArrows(coords[1], coords[2:4], col = "orange", length = 0.2, lwd = 1)
TernaryText(coords, cex = 0.8, col = "red", font = 2)
TernaryPoints(coords, pch = 1, cex = 2, col = "blue")
AddToTernary(graphics::points, coords, pch = 1, cex = 3)

# An equivalent syntax applies to Holdridge plots:
HoldridgePlot()
pet <- c(0.8, 2, 0.42)
prec <- c(250, 400, 1337)
HoldridgeText(pet, prec, c("A", "B", "C"))
AddToHoldridge(graphics::points, pet, prec, cex = 3)

# Restore original plotting parameters
par(oPar)
}
\seealso{
Other Holdridge plotting functions: 
\code{\link{HoldridgeHypsometricCol}()},
\code{\link{HoldridgePlot}()},
\code{\link{holdridge}},
\code{\link{holdridgeClasses}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{Holdridge plotting functions}
